#!/usr/bin/perl


=head1 METADATA

<crontab>
    time: */59 */12 * * *
    sharded: 1
    <switchman>
        group: scripts-other
    </switchman>
    package: scripts-switchman
</crontab>

<juggler>
    host:   checks_auto.direct.yandex.ru
    sharded: 1
    ttl: 37h
    tag: direct_group_internal_systems
</juggler>
<juggler_check>
    host:   checks_auto.direct.yandex.ru
    name: direct.client_teaser_data_lastupdate
    raw_events: direct.client_teaser_data_lastupdate.shard_$shard.production
    sharded: 1
    ttl: 37h
    tag: direct_group_internal_systems
</juggler_check>

=cut

=head1 NAME

    monitorCountryCurrencyLastUpdate.pl - мониторинг обновления валют стран

=head1 DESCRIPTION

    Опции:
    --shard-id - номер шарда для обработки
    --help - справка

=cut


use Direct::Modern;

use Yandex::DBTools;
use Yandex::DateTime;

use my_inc "..";

use Client::ConvertToRealMoney;
use ScriptHelper sharded => 1, 'Yandex::Log' => 'messages';
use Settings;


# thresholds in days
my $WARN_THRESHOLD = $Client::ConvertToRealMoney::COUNTRY_CURRENCY_LAST_UPDATE_INTERVAL_DAYS + 3;
my $CRIT_THRESHOLD = $WARN_THRESHOLD + 4;

my $SERVICE_NAME = "direct.client_teaser_data_lastupdate.shard_$SHARD";
my $CHECK_DESCRIPTION = 'Возраст (в днях) самого старого закэшированного объекта в БД';


extract_script_params();


$log->out('start');

my $max_days_since_last_update = get_one_field_sql(PPC(shard => $SHARD), '
    SELECT DATEDIFF(NOW(), MIN(IFNULL(ctdl.last_update, "2000-01-01")))
    FROM clients_to_force_multicurrency_teaser ctfmt
    LEFT JOIN client_teaser_data_lastupdate ctdl ON ctdl.ClientID = ctfmt.ClientID
    LEFT JOIN clients cl ON cl.ClientID = ctdl.ClientID
    WHERE
        IFNULL(cl.work_currency, "YND_FIXED") = "YND_FIXED"
');

$log->out("got max_days_since_last_update from DB: " . ($max_days_since_last_update // 'no data'));

if (!defined $max_days_since_last_update) {
    $log->out('no cached objects');
    $max_days_since_last_update = 0;
    $CHECK_DESCRIPTION = 'Нет закэшированных объектов';
}

juggler_check(
    'service' => $SERVICE_NAME,
    'warn' => $WARN_THRESHOLD,
    'crit' => $CRIT_THRESHOLD,
    'value' => $max_days_since_last_update,
    'description' => $CHECK_DESCRIPTION,
);

juggler_ok();

$log->out('finish');
