#!/usr/bin/perl

use my_inc "..";



=head1 METADATA

# monitorDirectResponseTime.pl: avg: 55 MB, max: 131 MB
<crontab>
    time: * * * * *
    <switchman>
        group: scripts-other
        <leases>
            mem: 130
        </leases>
    </switchman>
    package: scripts-switchman
</crontab>
<juggler>
    host:   checks_auto.direct.yandex.ru
    tag:    direct_group_internal_systems
</juggler>

=cut

=head1 NAME

    monitorDirectResponseTime.pl - подготовка данных о распределении времени ответа Директа для мониторинга

=head1 DESCRIPTION

    В результате работы создаются файлики, которые потом подхватываются забиксом
    Опции командной строки:
    --help - справка

=cut

use strict;
use warnings;

use Yandex::Advmon;
use Yandex::DBTools qw/sql_condition/;
use Yandex::TimeCommon qw/mysql2unix/;
use Yandex::DateTime qw//;

use Settings;
use ScriptHelper 'Yandex::Log' => 'messages';
use Tools qw//;

# каждую минуту пересчитываем данные за последние полчаса - если вдруг логи доехали
my $PERIOD = 30 * 60;

extract_script_params(
    'period=i' => \$PERIOD,
);

# ответы интерфейса
write_distribution(
    "interface_response",
    "direct.yandex.ru",
    {
        '' => [
            _OR => [
                request_url__like => '/public%',
                request_url__like => '/registered%',                
            ],
            ],
        camp_page => [
            _OR => [
                upstream_method => "showCamp",
            ]
        ],
        camp_list => [
            _OR => [
                upstream_method => "showCamps",
            ]
        ],
    }
    );
# ответы API
write_distribution(
    "api_response",
    "api.direct.yandex.ru",
    {
        '' => [
            ],
    }
    );
# ответы java-API
write_distribution(
    "java_api_response",
    "java-api.direct.yandex.ru",
    {
        '' => [
            ],
    }
    );

juggler_ok();

# принимаем имя файла и имя таблицы лога, считаем распределение времён ответа и записываем в файл
sub write_distribution {
    my ($file, $vhost, $adds) = @_;

    my $now_dt = Yandex::DateTime->now();
    my $from_dt = $now_dt->clone->subtract(seconds => $PERIOD)->set_second(0);
    my $to_dt = $now_dt->clone->set_second(0);

    my $clh = Tools::get_clickhouse_handler('cloud');

    my @quantiles = (80, 90, 95, 98, 99);
    my $quantiles_sql = join ',', map {$_/100} @quantiles;

    for my $name (keys %$adds) {
        my %cond = (
            vhost => $vhost,
            log_time__ge => "".$from_dt,
            log_time__lt => "".$to_dt,
            log_date__ge => "".$from_dt->date(),
            log_date__le => "".$to_dt->date(),
            @{$adds->{$name}},
        );

        # вариант для честного вычисления 5-минутных показателей
        #my $sql = "SELECT toStartOfMinute(date - time_shift * 60) as dt
        #                , count(*) as cnt
        #                , avg(time) as avg
        #                , quantiles($quantiles_sql)(time) as q 
        #             FROM (SELECT date, time, [0,1,2,3,4] as time_shift
        #                     FROM logs_direct
        #                    WHERE ".sql_condition(\%cond)."
        #                  )
        #                  ARRAY JOIN time_shift
        #            WHERE date - time_shift * 60 >= '$from_dt'
        #            GROUP BY dt
        #                  FORMAT JSON";
        my $sql = "SELECT toStartOfMinute(log_time) as dt
                        , count(*) as cnt
                        , avg(1000*request_time) as avg
                        , quantiles($quantiles_sql)(1000*request_time) as q 
                     FROM nginx_access
                    WHERE ".sql_condition(\%cond)."
                    GROUP BY dt
                          FORMAT JSON";

        for my $row (@{$clh->query($sql)->json->{data}}) {
            my %stat = (
                cnt => $row->{cnt},
                avg => $row->{avg},
            );
            for my $i (0..$#quantiles) {
                $stat{"proc".$quantiles[$i]} = $row->{q}->[$i];
            }
            my $time = mysql2unix($row->{dt});

            my $prefix = $name ? "$file.$name" : $file;
            $log->out({$prefix => \%stat});

            monitor_values({$prefix => \%stat}, time => $time);
        }
    }
}
