#!/usr/bin/perl

use my_inc "..";


=head1 METADATA

# limtest'ы под switchman, но без групп, т.к. запуск разделен пакетами с кронтабами.
<crontab>
    time: */2 * * * *
    <switchman>
    </switchman>
    package: scripts-limtest1
</crontab>
<crontab>
    time: */2 * * * *
    <switchman>
    </switchman>
    package: scripts-limtest2
</crontab>
<monrun>
    juggler_host:   checks_auto.direct.yandex.ru
    name: direct.limtest1.version_age
    warn: 1200
    expression: 'diffSeriesTime(keepLastValue(one_min.direct.production.direct.limtest.limtest1-direct.version_time))'
    tag: direct_gray
</monrun>
<monrun>
    juggler_host:   checks_auto.direct.yandex.ru
    name: direct.limtest1.version_status
    warn: 1
    expression: 'one_min.direct.production.direct.limtest.limtest1-direct.status'
    tag: direct_gray
</monrun>
<monrun>
    juggler_host:   checks_auto.direct.yandex.ru
    name: direct.limtest2.version_age
    warn: 1200
    expression: 'diffSeriesTime(keepLastValue(one_min.direct.production.direct.limtest.limtest2-direct.version_time))'
    tag: direct_gray
</monrun>
<monrun>
    juggler_host:   checks_auto.direct.yandex.ru
    name: direct.limtest2.version_status
    warn: 1
    expression: 'one_min.direct.production.direct.limtest.limtest2-direct.status'
    tag: direct_gray
</monrun>

=cut

=head1 NAME

    monitorLimTestVersion.pl - мониторинг версии софта на среде ограниченного тестирования

=head1 DESCRIPTION

    На среде ограниченного тестирования версия не должна быть меньше, чем на продакшене,
    проверяем это и выводим в файл статус

=cut

use strict;
use warnings;

use JSON;
use Sys::Hostname qw/hostname/;

use Yandex::Advmon;
use Yandex::HTTP;
use Yandex::Shell;

use Settings;
use ScriptHelper;

my $debian_package = 'yandex-direct';

# получаем версию Директа в продакшене
my $prod_conf_text = http_get("$Settings::DIRECT_INTAPI_URL/DirectConfiguration?keys=direct_version", timeout => 4)
    || die "Can't get direct_version from production";
my $production_version = JSON::decode_json($prod_conf_text)->{direct_version};
die "Can't get direct_version from production: no such key" if !defined $production_version;

# получаем версию локально-установленного Директа
my ($local_version) =
    map {(split(/\s+/))[2]}
    grep {/^\S+\s+\Q$debian_package\E\s+/}
    split /\n/, yash_qx('dpkg', '-l', $debian_package);

# сравниваем версии (только второе число - мажорную версию)
my $status = (split(/\D/, $production_version))[1] > (split(/\D/, $local_version))[1]
    ? 1 # error
    : 0 # ok
;
my $hostname = hostname();
$hostname =~ s/\./_/g;
monitor_values({
    "direct.limtest.$hostname.version_time" => time(), # XXX считать direct.limtest.HOST.version_age
    "direct.limtest.$hostname.status" => $status, # XXX summarize last за последние минуты
});
exit $status;
