#!/usr/bin/perl

=head1 DESCRIPTION

    Обновляет поле address_id в таблице vcards с 0 на null для всех vcard-ов созданных после 2017-10-18

=cut

use Direct::Modern;

use Yandex::DBTools;

use my_inc '../..';

use ScriptHelper;
use ShardingTools;
use Settings;

$log->out("START");

for my $shard (ppc_shards()) {
    my $guard = $log->msg_prefix_guard("[shard $shard]");

    FETCH_LOOP: for (;;) {
        $log->out("Fetching vcards with address_id = 0...");

        my $vcard_ids = get_one_column_sql(
            PPC(shard => $shard),
            ["SELECT vcard_id FROM vcards WHERE address_id = 0 and LastChange >= '2017-10-18' LIMIT 100"]
        );

        $log->out("Fetched " . scalar(@$vcard_ids) . " vcards");

        if (scalar(@$vcard_ids) == 0) {
            last FETCH_LOOP;
        }

        $log->out("Updating vcards:");
        $log->out({ vcard_ids => $vcard_ids });

        my $res = do_update_table(
            PPC(shard => $shard),
            'vcards',
            { address_id => undef },
            # Хотя вроде vcard-ы immutable-ы на всякий случай проверим на 0
            where => { vcard_id => $vcard_ids, address_id => 0 }
        );

        $log->out("Updated $res rows");
    }
}

$log->out("FINISH");
