#!/usr/bin/perl

=head1 DESCRIPTION

# approved by hrustyashko
# .migr
{
    type => 'script',
    when => 'any',
    time_estimate => '<10 сек на devtest.ppcdict',
    comment => 'Добавляем условия доп-соцдема для охватного продукта. Выполнить на всех TS и в проде.',
}

=cut

use Direct::Modern;
use Yandex::DBTools;
use my_inc "../..";
use ScriptHelper;
use Settings;

$log->out('START');

my $DATA = [ 
[2499000100, 0, "Семейное положение", "family", 0, 0, 0, 0, 0],
[2499000101, 2499000100, "Состоят в браке", "family", "crypta_family_status_married_name", "crypta_family_status_married_description", "long-term", 0, 0],
[2499000102, 2499000100, "Не состоят в браке", "family", "crypta_family_status_not_married_name", "crypta_family_status_not_married_description", "long-term", 217, 109],
[2499000110, 0, "Наличие детей", "family", 0, 0, 0, 0, 0],
[2499000111, 2499000110, "Планируют беременность или ждут рождение ребенка", "family", "crypta_family_planning_children_name", "crypta_family_planning_children_description", "long-term", 217, 565],
[2499000112, 2499000110, "Есть дети до 1 года", "family", "crypta_family_has_infants_name", "crypta_family_has_infants_description", "long-term", 217, 567],
[2499000113, 2499000110, "Есть дети 1–3 лет", "family", "crypta_family_has_children_1_3_name", "crypta_family_has_children_1_3_description", "long-term", 217, 580],
[2499000114, 2499000110, "Есть дети 3-6 лет", "family", "crypta_family_has_children_3_6_name", "crypta_family_has_children_3_6_description", "long-term", 217, 581],
[2499000115, 2499000110, "Есть дети 6-11 лет", "family", "crypta_family_has_children_6_11_name", "crypta_family_has_children_6_11_description", "long-term", 217, 582],
[2499000116, 2499000110, "Есть дети 11-16 лет", "family", "crypta_family_has_children_11_16_name", "crypta_family_has_children_11_16_description", "long-term", 217, 583],
[2499000120, 0, "Профессии", "family", 0, 0, 0, 0, 0],
[2499000121, 2499000120, "Таксисты", "family", "crypta_profession_taxi_driver_name", "crypta_profession_taxi_driver_description", "long-term", 216, 542],
[2499000122, 2499000120, "Маркетологи", "family", "crypta_profession_marketer_name", "crypta_profession_marketer_description", "long-term", 216, 628],
[2499000123, 2499000120, "Дизайнеры", "family", "crypta_profession_designer_name", "crypta_profession_designer_description", "long-term", 216, 634],
[2499000124, 2499000120, "Врачи", "family", "crypta_profession_medic_name", "crypta_profession_medic_description", "long-term", 216, 679],
[2499000125, 2499000120, "Юристы", "family", "crypta_profession_lawyer_name", "crypta_profession_lawyer_description", "long-term", 216, 680],
[2499000126, 2499000120, "Менеджеры по персоналу", "family", "crypta_profession_hr_specialist_name", "crypta_profession_hr_specialist_description", "long-term", 216, 681],
[2499000127, 2499000120, "Преподаватели", "family", "crypta_profession_teacher_name", "crypta_profession_teacher_description", "long-term", 216, 682],
[2499000128, 2499000120, "Финансисты", "family", "crypta_profession_financier_name", "crypta_profession_financier_description", "long-term", 216, 684],
[2499000129, 2499000120, "Разработчики", "family", "crypta_profession_software_developer_name", "crypta_profession_software_developer_description", "long-term", 216, 685],
[2499000130, 2499000120, "Менеджеры по закупкам", "family", "crypta_profession_purchasing_manager_name", "crypta_profession_purchasing_manager_description", "long-term", 216, 117],
];

$log->out("going to insert:", $DATA);

do_mass_insert_sql(PPCDICT, 'insert into crypta_goals (goal_id, parent_goal_id, name, crypta_goal_type, tanker_name_key, tanker_description_key, interest_type, bb_keyword, bb_keyword_value) values %s', $DATA);

$log->out("FINISH");
