#!/usr/bin/perl

=head1 NAME

=head1 DESCRIPTION

  Удаляем значение has_probabilistic_auction из campaigns

=cut

use my_inc "../..";

use Direct::Modern;

use Settings;
use Yandex::DBTools;
use ShardingTools qw/ppc_shards/;
use ScriptHelper;

$log->out('START');

for my $shard (ppc_shards()) {

    my @when_statements;

    my $opts_by_cid = get_hash_sql(PPC(shard => $shard), ['SELECT cid, opts  FROM campaigns WHERE opts like "%has_probabilistic_auction%"']);
    for my $cid (keys %$opts_by_cid) {
        my $opts = join( ',' =>  grep {$_ ne 'has_probabilistic_auction'} split( ',' => $opts_by_cid->{$cid} ) );
        push @when_statements, "WHEN cid = $cid and opts = '" . $opts_by_cid->{$cid} . "' THEN \'$opts\'";
        $log->out("For cid $cid, opts were " . $opts_by_cid->{$cid} . " become $opts");
    }

    if ( @when_statements ) {
        my $cnt = do_sql(PPC(shard => $shard),
            ["UPDATE campaigns SET opts = CASE " . join(' ', @when_statements) . " ELSE opts END",
                where => { cid => [keys %$opts_by_cid]}]);
        $log->out("$cnt of " . scalar %$opts_by_cid . " rows changed");
    }
    $log->out("shard $shard completed");
}

$log->out('FINISH');


