#!/usr/bin/perl

=head1 NAME

=head1 DESCRIPTION

Перезалить строки в таблицу product_restrictions.

=cut

use JSON qw/to_json/;
use Direct::Modern;

use Yandex::DBTools;

use my_inc "../..";

use ScriptHelper;
use Settings;

$log->out("START");

$log->out("going to delete all records from product_restrictions");

sub r {
    return {values => [], required => JSON::false, availableAny => JSON::false, @_};
}

sub restriction {
    return to_json(\@_)
}

my $geo = r(name => "geo", availableAny => JSON::true);
my $phrases = r(name => "phrases", availableAny => JSON::true);
my $advert_pages = r(name => "advert_pages");
my $social_demo = r(name => "social_demo");
my $family = r(name => "family");
my $behaviors = r(name => "behaviors");
my $interests = r(name => "interests");
my $audience = r(name => "audience");
my $audio_genres = r(name => "audio_genres");
my $goal_stat = r(name => "goal_stat", values => [{value => "0"}, {value => "25"},{value => "50"},{value => "100"}]);
my $correction_socdem = r(name => "correction_socdem");
my $correction_device = r(name => "correction_device");
my $correction_target_audience = r(name => "correction_target_audience");
my $correction_weather = r(name => "correction_weather");

do_in_transaction {

  do_sql(PPCDICT, "delete from product_restrictions");

  my $DATA = [
    [1,508587,"cpm_outdoor","outdoor","outdoor_description", restriction($advert_pages, $correction_socdem)],
    [2,508587,"cpm_banner","banner","banner description", restriction($geo, $social_demo, $family, $behaviors, $interests, $audience, $correction_device, $correction_weather)],
    [3,508587,"cpm_video","video","video description", restriction($geo, $goal_stat, $social_demo, $family, $behaviors, $interests, $audience, $correction_device, $correction_weather)],
    [4,508587,"cpm_audio","audio","audio description", restriction($geo, $goal_stat, $social_demo, $family, $behaviors, $interests, $audience, $audio_genres, $correction_device, $correction_weather)],
    [5,508587,"cpm_geoproduct","metro","metro description", restriction($geo, $social_demo, $family, $behaviors, $interests, $audience, $correction_device)],
    [6,508587,"cpm_indoor","indoor","indoor_description", restriction($advert_pages, $correction_socdem)],
    [7,508587,"cpm_banner","banner_text","banner_text description", restriction($geo, $phrases, $correction_target_audience, $correction_socdem, $correction_device, $correction_weather)],
    [20,508588,"cpm_outdoor","outdoor","outdoor_description", restriction($advert_pages, $correction_socdem)],
    [21,508588,"cpm_banner","banner","banner description", restriction($geo, $social_demo, $family, $behaviors, $interests, $audience, $correction_device, $correction_weather)],
    [22,508588,"cpm_video","video","video description", restriction($geo, $goal_stat, $social_demo, $family, $behaviors, $interests, $audience, $correction_device, $correction_weather)],
    [23,508588,"cpm_audio","audio","audio description", restriction($geo, $goal_stat, $social_demo, $family, $behaviors, $interests, $audience, $audio_genres, $correction_device, $correction_weather)],
    [24,508588,"cpm_geoproduct","metro","metro description", restriction($geo, $social_demo, $family, $behaviors, $interests, $audience, $correction_device)],
    [25,508588,"cpm_indoor","indoor","indoor_description", restriction($advert_pages, $correction_socdem)],
    [26,508588,"cpm_banner","banner_text","banner_text description", restriction($geo, $phrases, $correction_target_audience, $correction_socdem, $correction_device, $correction_weather)],
    [30,508589,"cpm_outdoor","outdoor","outdoor_description", restriction($advert_pages, $correction_socdem)],
    [31,508589,"cpm_banner","banner","banner description", restriction($geo, $social_demo, $family, $behaviors, $interests, $audience, $correction_device, $correction_weather)],
    [32,508589,"cpm_video","video","video description", restriction($geo, $goal_stat, $social_demo, $family, $behaviors, $interests, $audience, $correction_device, $correction_weather)],
    [33,508589,"cpm_audio","audio","audio description", restriction($geo, $goal_stat, $social_demo, $family, $behaviors, $interests, $audience, $audio_genres, $correction_device, $correction_weather)],
    [34,508589,"cpm_geoproduct","metro","metro description", restriction($geo, $social_demo, $family, $behaviors, $interests, $audience, $correction_device)],
    [35,508589,"cpm_indoor","indoor","indoor_description", restriction($advert_pages, $correction_socdem)],
    [36,508589,"cpm_banner","banner_text","banner_text description", restriction($geo, $phrases, $correction_target_audience, $correction_socdem, $correction_device, $correction_weather)],
    [40,508590,"cpm_outdoor","outdoor","outdoor_description", restriction($advert_pages, $correction_socdem)],
    [41,508590,"cpm_banner","banner","banner description", restriction($geo, $social_demo, $family, $behaviors, $interests, $audience, $correction_device, $correction_weather)],
    [42,508590,"cpm_video","video","video description", restriction($geo, $goal_stat, $social_demo, $family, $behaviors, $interests, $audience, $correction_device, $correction_weather)],
    [43,508590,"cpm_audio","audio","audio description", restriction($geo, $goal_stat, $social_demo, $family, $behaviors, $interests, $audience, $audio_genres, $correction_device, $correction_weather)],
    [44,508590,"cpm_geoproduct","metro","metro description", restriction($geo, $social_demo, $family, $behaviors, $interests, $audience, $correction_device)],
    [45,508590,"cpm_indoor","indoor","indoor_description", restriction($advert_pages, $correction_socdem)],
    [46,508590,"cpm_banner","banner_text","banner_text description", restriction($geo, $phrases, $correction_target_audience, $correction_socdem, $correction_device, $correction_weather)],
    [50,508591,"cpm_outdoor","outdoor","outdoor_description", restriction($advert_pages, $correction_socdem)],
    [51,508591,"cpm_banner","banner","banner description", restriction($geo, $social_demo, $family, $behaviors, $interests, $audience, $correction_device, $correction_weather)],
    [52,508591,"cpm_video","video","video description", restriction($geo, $goal_stat, $social_demo, $family, $behaviors, $interests, $audience, $correction_device, $correction_weather)],
    [53,508591,"cpm_audio","audio","audio description", restriction($geo, $goal_stat, $social_demo, $family, $behaviors, $interests, $audience, $audio_genres, $correction_device, $correction_weather)],
    [54,508591,"cpm_geoproduct","metro","metro description", restriction($geo, $social_demo, $family, $behaviors, $interests, $audience, $correction_device)],
    [55,508591,"cpm_indoor","indoor","indoor_description", restriction($advert_pages, $correction_socdem)],
    [56,508591,"cpm_banner","banner_text","banner_text description", restriction($geo, $phrases, $correction_target_audience, $correction_socdem, $correction_device, $correction_weather)],
    [60,508592,"cpm_outdoor","outdoor","outdoor_description", restriction($advert_pages, $correction_socdem)],
    [61,508592,"cpm_banner","banner","banner description", restriction($geo, $social_demo, $family, $behaviors, $interests, $audience, $correction_device, $correction_weather)],
    [62,508592,"cpm_video","video","video description", restriction($geo, $goal_stat, $social_demo, $family, $behaviors, $interests, $audience, $correction_device, $correction_weather)],
    [63,508592,"cpm_audio","audio","audio description", restriction($geo, $goal_stat, $social_demo, $family, $behaviors, $interests, $audience, $audio_genres, $correction_device, $correction_weather)],
    [64,508592,"cpm_geoproduct","metro","metro description", restriction($geo, $social_demo, $family, $behaviors, $interests, $audience, $correction_device)],
    [65,508592,"cpm_indoor","indoor","indoor_description", restriction($advert_pages, $correction_socdem)],
    [66,508592,"cpm_banner","banner_text","banner_text description", restriction($geo, $phrases, $correction_target_audience, $correction_socdem, $correction_device, $correction_weather)],
    [70,508594,"cpm_outdoor","outdoor","outdoor_description", restriction($advert_pages, $correction_socdem)],
    [71,508594,"cpm_banner","banner","banner description", restriction($geo, $social_demo, $family, $behaviors, $interests, $audience, $correction_device, $correction_weather)],
    [72,508594,"cpm_video","video","video description", restriction($geo, $goal_stat, $social_demo, $family, $behaviors, $interests, $audience, $correction_device, $correction_weather)],
    [73,508594,"cpm_audio","audio","audio description", restriction($geo, $goal_stat, $social_demo, $family, $behaviors, $interests, $audience, $audio_genres, $correction_device, $correction_weather)],
    [74,508594,"cpm_geoproduct","metro","metro description", restriction($geo, $social_demo, $family, $behaviors, $interests, $audience, $correction_device)],
    [75,508594,"cpm_indoor","indoor","indoor_description", restriction($advert_pages, $correction_socdem)],
    [76,508594,"cpm_banner","banner_text","banner_text description", restriction($geo, $phrases, $correction_target_audience, $correction_socdem, $correction_device, $correction_weather)],
    [80,508596,"cpm_outdoor","outdoor","outdoor_description", restriction($advert_pages, $correction_socdem)],
    [81,508596,"cpm_banner","banner","banner description", restriction($geo, $social_demo, $family, $behaviors, $interests, $audience, $correction_device, $correction_weather)],
    [82,508596,"cpm_video","video","video description", restriction($geo, $goal_stat, $social_demo, $family, $behaviors, $interests, $audience, $correction_device, $correction_weather)],
    [83,508596,"cpm_audio","audio","audio description", restriction($geo, $goal_stat, $social_demo, $family, $behaviors, $interests, $audience, $audio_genres, $correction_device, $correction_weather)],
    [84,508596,"cpm_geoproduct","metro","metro description", restriction($geo, $social_demo, $family, $behaviors, $interests, $audience, $correction_device)],
    [85,508596,"cpm_indoor","indoor","indoor_description", restriction($advert_pages, $correction_socdem)],
    [86,508596,"cpm_banner","banner_text","banner_text description", restriction($geo, $phrases, $correction_target_audience, $correction_socdem, $correction_device, $correction_weather)],
    [90,508892,"cpm_outdoor","outdoor","outdoor_description", restriction($advert_pages, $correction_socdem)],
    [91,508892,"cpm_banner","banner","banner description", restriction($geo, $social_demo, $family, $behaviors, $interests, $audience, $correction_device, $correction_weather)],
    [92,508892,"cpm_video","video","video description", restriction($geo, $goal_stat, $social_demo, $family, $behaviors, $interests, $audience, $correction_device, $correction_weather)],
    [93,508892,"cpm_audio","audio","audio description", restriction($geo, $goal_stat, $social_demo, $family, $behaviors, $interests, $audience, $audio_genres, $correction_device, $correction_weather)],
    [94,508892,"cpm_geoproduct","metro","metro description", restriction($geo, $social_demo, $family, $behaviors, $interests, $audience, $correction_device)],
    [95,508892,"cpm_indoor","indoor","indoor_description", restriction($advert_pages, $correction_socdem)],
    [96,508892,"cpm_banner","banner_text","banner_text description", restriction($geo, $phrases, $correction_target_audience, $correction_socdem, $correction_device, $correction_weather)],
    [100,508597,"cpm_outdoor","outdoor","outdoor_description", restriction($advert_pages, $correction_socdem)],
    [101,508597,"cpm_banner","banner","banner description", restriction($geo, $social_demo, $family, $behaviors, $interests, $audience, $correction_device, $correction_weather)],
    [102,508597,"cpm_video","video","video description", restriction($geo, $goal_stat, $social_demo, $family, $behaviors, $interests, $audience, $correction_device, $correction_weather)],
    [103,508597,"cpm_audio","audio","audio description", restriction($geo, $goal_stat, $social_demo, $family, $behaviors, $interests, $audience, $audio_genres, $correction_device, $correction_weather)],
    [104,508597,"cpm_geoproduct","metro","metro description", restriction($geo, $social_demo, $family, $behaviors, $interests, $audience, $correction_device)],
    [105,508597,"cpm_indoor","indoor","indoor_description", restriction($advert_pages, $correction_socdem)],
    [106,508597,"cpm_banner","banner_text","banner_text description", restriction($geo, $phrases, $correction_target_audience, $correction_socdem, $correction_device, $correction_weather)]
  ];

  $log->out("going to insert:", $DATA);

  do_mass_insert_sql(PPCDICT, "insert into product_restrictions (id, ProductID, adgroup_type, public_name_key, public_description_key, condition_json) values %s", $DATA);
};

$log->out("FINISH");
