#!/usr/bin/perl

=head1 NAME

=head1 DESCRIPTION

Перезалить строки в таблицу product_restrictions по аудио жанрам.

=cut

use JSON qw/to_json/;
use Direct::Modern;

use Yandex::DBTools;

use my_inc "../..";

use ScriptHelper;
use Settings;

$log->out("START");

$log->out("going to delete records for indoor+outdoor from product_restrictions");

sub r {
    return {values => [], required => JSON::false, availableAny => JSON::false, @_};
}

sub restriction {
    return to_json(\@_)
}

my $geo = r(name => "geo", availableAny => JSON::true);
my $phrases = r(name => "phrases", availableAny => JSON::true);
my $advert_pages = r(name => "advert_pages");
my $advert_pages_indoor = r(name => "advert_pages_indoor");
my $advert_pages_outdoor = r(name => "advert_pages_outdoor");
my $social_demo = r(name => "social_demo");
my $family = r(name => "family");
my $behaviors = r(name => "behaviors");
my $interests = r(name => "interests");
my $audience = r(name => "audience");
my $audio_genres = r(name => "audio_genres");
my $goal_stat = r(name => "goal_stat", values => [{value => "0"}, {value => "25"},{value => "50"},{value => "100"}]);
my $goal_stat_start = r(name => "goal_stat", values => [{value => "1"}]);
my $correction_socdem = r(name => "correction_socdem");
my $correction_device = r(name => "correction_device");
my $correction_target_audience = r(name => "correction_target_audience");
my $correction_weather = r(name => "correction_weather");

do_in_transaction {

  do_sql(PPCDICT, "delete from product_restrictions where id in (6,25,35,45,55,65,75,85,95,105,1,20,30,40,50,60,70,80,90,100)");

  my $DATA = [
    [6,508587,"cpm_indoor","indoor","indoor_description", restriction($goal_stat_start, $advert_pages_indoor, $correction_socdem)],
    [25,508588,"cpm_indoor","indoor","indoor_description", restriction($goal_stat_start, $advert_pages_indoor, $correction_socdem)],
    [35,508589,"cpm_indoor","indoor","indoor_description", restriction($goal_stat_start, $advert_pages_indoor, $correction_socdem)],
    [45,508590,"cpm_indoor","indoor","indoor_description", restriction($goal_stat_start, $advert_pages_indoor, $correction_socdem)],
    [55,508591,"cpm_indoor","indoor","indoor_description", restriction($goal_stat_start, $advert_pages_indoor, $correction_socdem)],
    [65,508592,"cpm_indoor","indoor","indoor_description", restriction($goal_stat_start, $advert_pages_indoor, $correction_socdem)],
    [75,508594,"cpm_indoor","indoor","indoor_description", restriction($goal_stat_start, $advert_pages_indoor, $correction_socdem)],
    [85,508596,"cpm_indoor","indoor","indoor_description", restriction($goal_stat_start, $advert_pages_indoor, $correction_socdem)],
    [95,508892,"cpm_indoor","indoor","indoor_description", restriction($goal_stat_start, $advert_pages_indoor, $correction_socdem)],
    [105,508597,"cpm_indoor","indoor","indoor_description", restriction($goal_stat_start, $advert_pages_indoor, $correction_socdem)],
    [1,508587,"cpm_outdoor","outdoor","outdoor_description", restriction($goal_stat_start, $advert_pages_outdoor, $correction_weather)],
    [20,508588,"cpm_outdoor","outdoor","outdoor_description", restriction($goal_stat_start, $advert_pages_outdoor, $correction_weather)],
    [30,508589,"cpm_outdoor","outdoor","outdoor_description", restriction($goal_stat_start, $advert_pages_outdoor, $correction_weather)],
    [40,508590,"cpm_outdoor","outdoor","outdoor_description", restriction($goal_stat_start, $advert_pages_outdoor, $correction_weather)],
    [50,508591,"cpm_outdoor","outdoor","outdoor_description", restriction($goal_stat_start, $advert_pages_outdoor, $correction_weather)],
    [60,508592,"cpm_outdoor","outdoor","outdoor_description", restriction($goal_stat_start, $advert_pages_outdoor, $correction_weather)],
    [70,508594,"cpm_outdoor","outdoor","outdoor_description", restriction($goal_stat_start, $advert_pages_outdoor, $correction_weather)],
    [80,508596,"cpm_outdoor","outdoor","outdoor_description", restriction($goal_stat_start, $advert_pages_outdoor, $correction_weather)],
    [90,508892,"cpm_outdoor","outdoor","outdoor_description", restriction($goal_stat_start, $advert_pages_outdoor, $correction_weather)],
    [100,508597,"cpm_outdoor","outdoor","outdoor_description", restriction($goal_stat_start, $advert_pages_outdoor, $correction_weather)]
  ];

  $log->out("going to insert:", $DATA);

  do_mass_insert_sql(PPCDICT, "insert into product_restrictions (id, ProductID, adgroup_type, public_name_key, public_description_key, condition_json) values %s", $DATA);
};

$log->out("FINISH");
