#!/usr/bin/perl

=head1 NAME

=head1 DESCRIPTION

Перезалить строки в таблицу product_restrictions по аудио жанрам.

=cut

use JSON qw/to_json/;
use Direct::Modern;

use Yandex::DBTools;

use my_inc "../..";

use ScriptHelper;
use Settings;

$log->out("START");

$log->out("going to delete all records from product_restrictions");

sub r {
    return {values => [], required => JSON::false, availableAny => JSON::false, @_};
}

sub restriction {
    return to_json(\@_)
}

my $geo = r(name => "geo", availableAny => JSON::true);
my $phrases = r(name => "phrases", availableAny => JSON::true);
my $advert_pages = r(name => "advert_pages");
my $social_demo = r(name => "social_demo");
my $family = r(name => "family");
my $behaviors = r(name => "behaviors");
my $interests = r(name => "interests");
my $audience = r(name => "audience");
my $audio_genres = r(name => "audio_genres");
my $goal_stat = r(name => "goal_stat", values => [{value => "0"}, {value => "25"},{value => "50"},{value => "100"}]);
my $correction_socdem = r(name => "correction_socdem");
my $correction_device = r(name => "correction_device");
my $correction_target_audience = r(name => "correction_target_audience");
my $correction_weather = r(name => "correction_weather");

do_in_transaction {

  do_sql(PPCDICT, "delete from product_restrictions where id in (4,23,33,43,53,63,73,83,93,103)");

  my $DATA = [
    [4,508587,"cpm_audio","audio","audio description", restriction($geo, $audio_genres, $goal_stat, $social_demo, $family, $behaviors, $interests, $audience, $correction_weather)],
    [23,508588,"cpm_audio","audio","audio description", restriction($geo, $audio_genres, $goal_stat, $social_demo, $family, $behaviors, $interests, $audience, $correction_weather)],
    [33,508589,"cpm_audio","audio","audio description", restriction($geo, $audio_genres, $goal_stat, $social_demo, $family, $behaviors, $interests, $audience, $correction_weather)],
    [43,508590,"cpm_audio","audio","audio description", restriction($geo, $audio_genres, $goal_stat, $social_demo, $family, $behaviors, $interests, $audience, $correction_weather)],
    [53,508591,"cpm_audio","audio","audio description", restriction($geo, $audio_genres, $goal_stat, $social_demo, $family, $behaviors, $interests, $audience, $correction_weather)],
    [63,508592,"cpm_audio","audio","audio description", restriction($geo, $audio_genres, $goal_stat, $social_demo, $family, $behaviors, $interests, $audience, $correction_weather)],
    [73,508594,"cpm_audio","audio","audio description", restriction($geo, $audio_genres, $goal_stat, $social_demo, $family, $behaviors, $interests, $audience, $correction_weather)],
    [83,508596,"cpm_audio","audio","audio description", restriction($geo, $audio_genres, $goal_stat, $social_demo, $family, $behaviors, $interests, $audience, $correction_weather)],
    [93,508892,"cpm_audio","audio","audio description", restriction($geo, $audio_genres, $goal_stat, $social_demo, $family, $behaviors, $interests, $audience, $correction_weather)],
    [103,508597,"cpm_audio","audio","audio description", restriction($geo, $audio_genres, $goal_stat, $social_demo, $family, $behaviors, $interests, $audience, $correction_weather)],
  ];

  $log->out("going to insert:", $DATA);

  do_mass_insert_sql(PPCDICT, "insert into product_restrictions (id, ProductID, adgroup_type, public_name_key, public_description_key, condition_json) values %s", $DATA);
};

$log->out("FINISH");
