#!/usr/bin/perl

=head1 NAME

=head1 DESCRIPTION

Обновить ссылки на js-библиотеки в mds с правильным mimeType-ом в текущих креативах

=cut

use JSON qw/from_json/;
use Direct::Modern;
use Path::Tiny;

use Yandex::TVM2;
use Yandex::HTTP qw/http_fetch/;

use my_inc "../..";

use ScriptHelper;
use Settings;

$log->out("START");

my ($do_update, $filename);
extract_script_params(
   "do_update" => \$do_update,
   "filename=s" => \$filename,
);

die "param --filename is not defined" unless $filename;
$do_update = $do_update ? 'true' : 'false';

local $Yandex::TVM2::APP_ID = $Settings::TVM2_APP_ID{scripts};
local $Yandex::TVM2::SECRET_PATH = $Settings::TVM2_SECRET_PATH{scripts};
my $ticket = eval{Yandex::TVM2::get_ticket($Settings::TVM2_APP_ID{canvas})} 
        or $log->die("Cannot get ticket for $Settings::TVM2_APP_ID{canvas}: $@");

my $url = $Settings::BASE_CANVAS_URL . '/wrongJsSources/';
$log->out($url);

my %request_perams = (
  timeout => 60 *60,
  log => $log,
  headers => {
    'Accept' => 'application/json',
    'X-Ya-Service-Ticket' => $ticket,
  }
);
my $content = path($filename)->slurp;

my $content_json = from_json($content);
if (%$content_json){
  # записываем в mongo пути к новым js файлам
  my $update_content = http_fetch('POST' => $url . "update?do_update=$do_update", $content, %request_perams);
  $log->out('UPDATE: ' . $update_content);

  my $result = from_json($update_content);
  $log->out('UPDATE Ids: ' . join ', ' => keys %$result);
  $log->out('OK') if %$result;
}

$log->out("FINISH");

