#!/usr/bin/perl

=head1 NAME

=head1 DESCRIPTION

Перезалить js-библиотеки в mds с правильным mimeType-ом

=cut

use Direct::Modern;

use Yandex::TVM2;
use Yandex::HTTP qw/http_fetch/;

use my_inc "../..";

use ScriptHelper;
use Settings;

$log->out("START");

my ($not_only_get, $client_id, $filename);
extract_script_params(
   "not_only_get" => \$not_only_get,
   "client_id=i" => \$client_id,
   "filename=s" => \$filename,
);

die "param --filename is not defined" unless $filename;

local $Yandex::TVM2::APP_ID = $Settings::TVM2_APP_ID{scripts};
local $Yandex::TVM2::SECRET_PATH = $Settings::TVM2_SECRET_PATH{scripts};
my $ticket = eval{Yandex::TVM2::get_ticket($Settings::TVM2_APP_ID{canvas})} 
        or $log->die("Cannot get ticket for $Settings::TVM2_APP_ID{canvas}: $@");

my $url = $Settings::BASE_CANVAS_URL . '/wrongJsSources/';
$log->out($url);

my %request_perams = (
  timeout => 100,
  log => $log,
  headers => {
    'Accept' => 'application/json',
    'X-Ya-Service-Ticket' => $ticket,
  }
);

if ($not_only_get) {
  my $upload_url = $url . 'upload';
  $upload_url .= "?client_id=$client_id" if $client_id;
  # ищем креативы у которых есть js файлы и повторно загружаем их в mds с правильным content-type
  my $upload_content = http_fetch('POST' => $upload_url, '', %request_perams);
  $log->out('UPLOAD: ' . $upload_content);

  open(my $fh, '>', $filename) or die $!;
  print $fh $upload_content;
  close $fh;
} else {
  my $get_url = $url . 'get';
  $get_url .= "?client_id=$client_id" if $client_id;

  # в mongo ищем креативы у которых есть js файлы
  my $response_get = http_fetch('GET' => $get_url, undef, %request_perams);
  $log->out('GET: ' . $response_get);
}

$log->out("FINISH");
