#!/usr/bin/perl

=head1 NAME

=head1 DESCRIPTION

    Добавление целей brandsafety, они должны находиться в том же неймспейсе, что и сегменты крипты.

=cut

use Direct::Modern;

use Yandex::DBTools;

use my_inc "../..";

use ScriptHelper;
use Settings;

$log->out('START');

$log->out("going to delete records from crypta_goals to prevent duplicates");

do_sql(PPCDICT, "alter table crypta_goals modify column crypta_goal_type enum('social_demo','family','interests','behaviors','audio_genres', 'brandsafety') not null after name");
do_sql(PPCDICT, "delete from crypta_goals where crypta_goal_type = 'brandsafety' and tanker_name_key in ('brandsafety_adult_name', 'brandsafety_terrorism_name', 'brandsafety_negative_name', 'brandsafety_weapons_name', 'brandsafety_obscene_name', 'brandsafety_politics_name', 'brandsafety_children_name', 'brandsafety_gambling_name', 'brandsafety_news_name', 'brandsafety_torrent_name', 'brandsafety_religion_name', 'brandsafety_videogames_name', 'brandsafety_dating_name', "
." 'brandsafety_medicine_name', 'brandsafety_alcohol_name', 'brandsafety_tobacco_name', 'brandsafety_occultism_name')");

my $DATA = [
    [4294967297, "brandsafety", "Содержание только для взрослых", "brandsafety_adult_name", "brandsafety_adult_description", "all"],
    [4294967298, "brandsafety", "Материалы о терроризме", "brandsafety_terrorism_name", "brandsafety_terrorism_description", "all"],
    [4294967299, "brandsafety", "Негативный контент", "brandsafety_negative_name", "brandsafety_negative_description", "all"],
    [4294967300, "brandsafety", "Оружие", "brandsafety_weapons_name", "brandsafety_weapons_description", "all"],
    [4294967301, "brandsafety", "Нецензурная лексика", "brandsafety_obscene_name", "brandsafety_obscene_description", "all"],
    [4294967302, "brandsafety", "Политика", "brandsafety_politics_name", "brandsafety_politics_description", "all"],
    [4294967303, "brandsafety", "Детский контент", "brandsafety_children_name", "brandsafety_children_description", "all"],
    [4294967304, "brandsafety", "Азартные игры", "brandsafety_gambling_name", "brandsafety_gambling_description", "all"],
    [4294967305, "brandsafety", "Новостной контент", "brandsafety_news_name", "brandsafety_news_description", "all"],
    [4294967306, "brandsafety", "Раздача контента", "brandsafety_torrent_name", "brandsafety_torrent_description", "all"],
    [4294967307, "brandsafety", "Религия", "brandsafety_religion_name", "brandsafety_religion_description", "all"],
    [4294967308, "brandsafety", "Игры", "brandsafety_videogames_name", "brandsafety_videogames_description", "all"],
    [4294967309, "brandsafety", "Знакомства", "brandsafety_dating_name", "brandsafety_dating_description", "all"],
    [4294967310, "brandsafety", "Медицинский контент", "brandsafety_medicine_name", "brandsafety_medicine_description", "all"],
    [4294967311, "brandsafety", "Алкоголь", "brandsafety_alcohol_name", "brandsafety_alcohol_description", "all"],
    [4294967312, "brandsafety", "Табак", "brandsafety_tobacco_name", "brandsafety_tobacco_description", "all"],
    [4294967313, "brandsafety", "Оккультизм и паранормальные явления", "brandsafety_occultism_name", "brandsafety_occultism_description", "all"]
];
$log->out("going to insert:", $DATA);

do_mass_insert_sql(PPCDICT, 'insert into crypta_goals (goal_id, crypta_goal_type, name, tanker_name_key, tanker_description_key, interest_type) values %s', $DATA);

$log->out("FINISH");
