#!/usr/bin/perl

use Direct::Modern;

use Yandex::DBTools;

use my_inc "../..";

use ScriptHelper;
use Settings;

# Последний goal_id из базы получил так: direct-sql pr:ppcdict 'select MAX(goal_id) from crypta_goals where scope = "internal_ad"'
# MAX(goal_id): 2499982097

my $SEGMENTS = [
    [ 2499982098, 2499980090, "Клиенты категории \"Медицина\"", "internal", "crypta_segment-1a1b7e1b_name", "crypta_segment-1a1b7e1b_description", "all", "", "546", "1758", "", "", "internal_ad" ],
    [ 2499982099, 2499980090, "Клиенты категории \"Путешествия и туризм\"", "internal", "crypta_segment-46e7bbba_name", "crypta_segment-46e7bbba_description", "all", "", "546", "1759", "", "", "internal_ad" ],

    [ 2499982100, 2499980007, "Владельцы бизнеса", "internal", "crypta_segment-491880e1_name", "crypta_segment-491880e1_description", "all", "", "549", "1768", "", "", "internal_ad" ],
    [ 2499982101, 2499980007, "Владельцы бизнеса", "internal", "crypta_segment-491880e1_name", "crypta_segment-491880e1_description", "all", "", "546", "1769", "", "", "internal_ad" ],

    [ 2499982102, 2499980086, "Интересуются ОФД", "internal", "crypta_segment-b839a0e7_name", "crypta_segment-b839a0e7_description", "all", "", "546", "1767", "", "", "internal_ad" ],
    [ 2499982103, 2499980086, "Интересуются ОФД", "internal", "crypta_segment-b839a0e7_name", "crypta_segment-b839a0e7_description", "all", "", "549", "1766", "", "", "internal_ad" ],
];

my $OTHER_SEGMENTS = [
    [ 2499982104, 2499000120, "Дизайнеры", "family", "crypta_segment-profession_designer_name", "crypta_segment-profession_designer_description", "long-term", "", "216", "634", "", "", "internal_ad" ],
];

sub insert_data {
    my ($data) = @_;
    $log->out("going to insert:", $data);
    do_mass_insert_sql(PPCDICT, 'insert into crypta_goals (goal_id, parent_goal_id, name, crypta_goal_type, tanker_name_key, tanker_description_key, interest_type, tags, bb_keyword, bb_keyword_value, bb_keyword_short, bb_keyword_value_short, scope) values %s', $data);
}

$log->out('START');

insert_data($SEGMENTS);
insert_data($OTHER_SEGMENTS);

$log->out("FINISH");
