#!/usr/bin/perl

use Direct::Modern;

use Yandex::DBTools;

use my_inc "../..";

use ScriptHelper;
use Settings;

# Последний goal_id из базы получил так: direct-sql pr:ppcdict 'select MAX(goal_id) from crypta_goals where scope = "internal_ad"'
# MAX(goal_id): 2499982104

my $GROUPS = [
    [ 2499982105, 2499980002, "Поведение", "internal", "crypta_group-9190c100_name", "crypta_group-9190c100_description", "all", "", "0", "0", "", "", "internal_ad" ],
    [ 2499982106, 2499982105, "Транспорт", "internal", "crypta_group-c3198159_name", "crypta_group-c3198159_description", "all", "", "0", "0", "", "", "internal_ad" ],
];

my $SEGMENTS = [
    [ 2499982107, 2499982106, "Автомобилисты", "internal", "crypta_segment-a8ad04fd_name", "crypta_segment-a8ad04fd_description", "all", "", "216", "519", "", "", "internal_ad" ],
];

sub insert_data {
    my ($data) = @_;
    $log->out("going to insert:", $data);
    do_mass_insert_sql(PPCDICT, 'insert into crypta_goals (goal_id, parent_goal_id, name, crypta_goal_type, tanker_name_key, tanker_description_key, interest_type, tags, bb_keyword, bb_keyword_value, bb_keyword_short, bb_keyword_value_short, scope) values %s', $data);
}

$log->out('START');

insert_data($GROUPS);
insert_data($SEGMENTS);

$log->out("FINISH");
