#!/usr/bin/env perl

use my_inc "../..";

use Direct::Modern;

=head1 DESCRIPTION

    Восстанавливаем приязку ряда баннеров к нужному шарду в метабазе (DIRECT-41557)

=cut

use Settings;

use ScriptHelper;

use Yandex::DBShards;
use Yandex::DBTools;
use ShardingTools;

$log->out('START');

# Прочитаем список затронутых баннеров
my @banner_ids = join('', <DATA>) =~ /(\d+)/sg;
my $meta_shards = get_shard_multi(bid => \@banner_ids);

# Отфильтруем баннеры без привязки в метабазе
my @banners_ids_no_shard = grep { !$meta_shards->{$_} } @banner_ids;

# Посмотрим, какие из них находятся в БД и в каком шарде
my %banner_id2real_shard;
for my $shard (ppc_shards()) {
    my $bid2cid_in_this_shard = get_hash_sql(PPC(shard => $shard), ["SELECT bid, cid FROM banners", where => {bid => \@banners_ids_no_shard}]);
    for my $id (keys %$bid2cid_in_this_shard) {
        push @{ $banner_id2real_shard{$id} }, {shard => $shard, cid => $bid2cid_in_this_shard->{$id}};
    }
}

$log->out("Found: ".(scalar keys %banner_id2real_shard)." banners");

# Получилось ~23 "пострадавших" баннера. Восстановим записи в метабазе;
while (my ($id, $data_multi) = each %banner_id2real_shard) {

    # Если баннер находится сразу в нескольких шардах, выведем предупреждение
    if (@$data_multi > 1) {
        $log->warn({"Found banner #${id} in different shards:" => $data_multi});
        next;
    }

    # Сохраним привязку к шарду
    my ($shard, $cid) = @{$data_multi->[0]}{qw/shard cid/};
    $log->out("Saving banner #${id} in shard:${shard} using cid:${cid}");
    save_shard(bid => $id, cid => $cid);
}

$log->out('END');

__DATA__
627774544,627774686,627774535,627774620,627774679,627774614,627774713,627774684,627774623,627774662,627774513,627774628,
627774634,627774593,627774680,627774572,627774655,627774652,627774499,627774483,627774579,627774498,627774555,627774646,
627774519,627774453,627774637,627774527,627774510,627774697,627774557,627774675,627774720,627774450,627774462,627774505,
627774639,627774552,627774556,627774605,627774663,627774470,627774625,627774674,627774696,627774459,627774705,627774596,
627774691,627774473,627774524,627774642,627774586,627774611,627774454,627774585,627774487,627774659,627774547,627774681,
627774608,627774494,627774719,627774575,627774491,627774661,627774685,627774564,627774457,627774603,627774573,627774624,
627774562,627774452,627774707,627774558,627774554,627774613,627774478,627774724,627774531,627774506,627774451,627774495,
627774482,627774678,627774658,627774599,627774582,627774683,627774708,627774581,627774716,627774600,627774721,627774518,
627774651,627774647,627774601,627774486,627774489,627774636,627774455,627774521,627774570,627774670,627774712,627774567,
627774476,627774548,627774701,627774700,627774461,627774587,627774481,627774669,627774629,627774692,627774480,627774610,
627774537,627774502,627774551,627774633,627774568,627774643,627774464,627774517,627774523,627774671,627774458,627774617,
627774448,627774490,627774704,627774668,627774576,627774590,627774650,627774496,627774654,627774688,627774520,627774699,
627774559,627774530,627774722,627774706,627774693,627774595,627774635,627774574,627774657,627774695,627774560,627774607,
627774456,627774500,627774549,627774604,627774577,627774632,627774619,627774550,627774690,627774566,627774477,627774563,
627774507,627774475,627774709,627774626,627774492,627774540,627774539,627774621,627774522,627774666,627774460,627774660,
627774580,627774616,627774515,627774717,627774672,627774529,627774536,627774588,627774516,627774715,627774711,627774583,
627774465,627774512,627774726,627774656,627774472,627774648,627774526,627774449,627774598,627774532,627774485,627774545,
627774645,627774591,627774667,627774687,627774649,627774641,627774638,627774694,627774640,627774703,627774676,627774509,
627774534,627774569,627774511,627774592,627774627,627774631,627774543,627774653,627774497,627774618,627774698,627774463,
627774594,627774503,627774597,627774541,627774665,627774468,627774725,627774538,627774644,627774561,627774606,627774578,
627774723,627774484,627774609,627774546,627774488,627774553,627774571,627774714,627774514,627774474,627774589,627774664,
627774702,627774615,627774710,627774533,627774528,627774622,627774584,627774718,627774504,627774525,627774469,627774565,
627774542,627774630,627774602,627774466,627774612,627774479,627774673,627774682,627774471,627774493,627774677,627774467,
627774689,627774501,627774508
