#!/usr/bin/perl

=head1 USAGE

    ./protected/one-shot/63976_export_media_resource_videos.pl > media_resource_videos.txt

=cut

use Direct::Modern;
use my_inc '../..';

use JSON;

use Settings;

use ScriptHelper;
use Yandex::DBTools;

use RBAC2::Extended qw/get_singleton/;
use RBACDirect qw/rbac_mass_get_agencies_of_clients/;
use RBACElementary qw/rbac_get_chief_reps_of_clients/;

binmode STDOUT, ':utf8';

my $OPERATOR_UID = 1;

my $rbac = eval { RBAC2::Extended->get_singleton($OPERATOR_UID) }
    or $log->die("Can't connect to RBAC: $@");

my $rows = get_all_sql(PPC(shard => 'all'), "
    SELECT DISTINCT ClientID, used_resources
    FROM banner_resources
        JOIN banners USING (bid)
        JOIN campaigns USING (cid)
");

my %resource_to_client;
for my $row (@$rows) {
    my $client_id = $row->{ClientID};
    my $resources = from_json($row->{used_resources});

    for (@$resources) {
        $resource_to_client{$_}{$client_id} = 1
    }
}

my @clientIds = map {$_->{ClientID}} @$rows;
my $clientIdToOperatorUid = get_client_id_to_operator_uid_map(\@clientIds);

my $resources = get_hashes_hash_sql(PPCDICT(), "
    SELECT media_resource_id, name, colors, resources_url
    FROM media_resources
    # WHERE resource_type = 'video'
");

for my $rid (keys %$resources) {
    my $r = $resources->{$rid};
    my $clients = [ map { [$_ + 0, $clientIdToOperatorUid->{$_} + 0] } keys %{$resource_to_client{$rid}} ];
    next unless @$clients;
    my $urls = from_json($r->{resources_url});

    my $row = {
        media_resource_id => $rid + 0,
        name => $r->{name},
        color => $r->{colors},
        clients => $clients,
        resources_url => $urls,
    };

    say to_json($row);
    # а вот так можно сделать фейковый маппинг для миграции one-shot/63976_migrate_resources_video_to_creatives.pl
    # for my $c (@$client_ids) {
    #     say join("\t", $c, $rid, $c * 1000 + $rid);
    # }
}

sub get_client_id_to_operator_uid_map {
    my ($clientIds) = @_;
    my $clientid2chiefuid = rbac_get_chief_reps_of_clients($clientIds);
    my $uidsToAgencyUids = rbac_mass_get_agencies_of_clients($rbac, [values %{$clientid2chiefuid}]);
    for my $key (keys %$clientid2chiefuid) {
        my $agency_uids = $uidsToAgencyUids->{$clientid2chiefuid->{$key}};
        if (@$agency_uids) {
            $clientid2chiefuid->{$key} = $agency_uids->[0];
        }
    }
    return $clientid2chiefuid;
}
