#!/usr/bin/perl

=head1 USAGE

    ./protected/one-shot/63976_revert_video_migration_from_logs.pl [--since=12:34:56] [--till=15:22:08] <log filepath>

=head1 DESCRIPTION

    Читает лог от миграции 63976_migrate_resources_video_to_creatives.pl и откатывает изменения в БД
    Если не хочется откатывать весь лог, можно указать диапазон временных меток

    Параметры
        <log filepath> - путь к файлу с логами

    Опции:
        --since - временная метка, с которой нужно начать читать лог *включительно*
        --till - временная метка, до которой нужно читать лог *включительно*
        --help - справка

=cut

use Direct::Modern;

use JSON;

use Yandex::DBTools;
use Yandex::Retry qw/relaxed_guard/;

use my_inc '../..';

use ScriptHelper;
use Settings;

extract_script_params(
        'since=s' => \my $since,
        'till=s' => \my $till,
    );

my ($log_file) = @ARGV;

unless ($log_file && -f $log_file) {
    usage();
}

my $ops_re = 'deleting from banner_resources|inserting into banners_performance records with ids|auto accepting bids on moderation';

my $SLEEP_COEF = 1;

open my $fh, "<:utf8", $log_file or die "can't open $log_file: $!";

$log->out("START");

while (<$fh>) {
    chomp;
    my $relax = relaxed_guard(times => $SLEEP_COEF);

    my ($timestamp, $shard, $op, $details) = $_ =~ /(\d{2}:\d{2}:\d{2})\s+\[shard (\d+)\]\s+($ops_re): (.*)/;
    next unless $op;

    next if $since && $timestamp lt $since;
    next if $till && $timestamp gt $till;

    my $data = from_json($details);
    $log->out("[shard $shard]\treverting $op: $details");
    if ($op eq 'deleting from banner_resources') {
        my @mass_insert_rows = map { [ @$_{qw/resource_id bid used_resources/} ] } @$data;
        my $inserted = do_mass_insert_sql(PPC(shard => $shard), "INSERT IGNORE INTO banner_resources(resource_id, bid, used_resources) VALUES %s", \@mass_insert_rows) + 0;
        $log->out("[shard $shard]\tinserted $inserted/".scalar(@mass_insert_rows));
    } elsif ($op eq 'inserting into banners_performance records with ids') {
        my $deleted = do_delete_from_table(PPC(shard => $shard), "banners_performance", where => {banner_creative_id => $data}) + 0;
        $log->out("[shard $shard]\tdeleted $deleted/".scalar(@$data));
    } elsif ($op eq 'auto accepting bids on moderation') {
        my $deleted = do_delete_from_table(PPC(shard => $shard), 'auto_moderate', where => {bid => $data}) + 0;
        $log->out("[shard $shard]\tdeleted $deleted/".scalar(@$data));
    }
}

$log->out("FINISH");
