#!/usr/bin/env perl

=head1 SYNOPSIS

    ./64082-disable-autopayment-less-1000.pl
    можно запускать с параметрами например (./64082-disable-autopayment-less-1000.pl --clientID=10944595 --clientID=19959369 --shard=10)

    Сохраняет список id кошельков которым скриптом отключилось автопополнение
    в переменную PPCDICT ppc_properties.wallet_ids_stopped_autopay_by_script
    (умеет читать пропертю, добавлять к ней новые кошельки, сохранять все вместе)

=head1 DESCRIPTION

    Скрипт для отключения автопополнения у клиентов использующих автопополнение на сумму меньше 1000 р
    отключение 29 марта 2017 утром в 12.00
    https://st.yandex-team.ru/DIRECT-64082


=cut

use strict;
use warnings;
use my_inc '../..';


use List::MoreUtils qw/all/;

use ShardingTools;
use Settings;
use ScriptHelper;
use Yandex::DBTools;

my (@clientIDs, @shards);
extract_script_params(
    'clientID=i' => \@clientIDs,
    'shard=i' => \@shards,
);

my %valid_shards = map { $_ => 1 } ppc_shards();
@shards = grep { $valid_shards{$_} } @shards;
@shards = keys %valid_shards unless @shards;

my @changed_wallet_ids;
for my $shard (@shards) {
        $log->msg_prefix("[shard$shard]");
        my $wallets_for_update= get_all_sql(PPC(shard => $shard), ["select aus.wallet_cid, aus.payment_sum
                                                         from wallet_campaigns wc join autopay_settings aus using (wallet_cid) ",
                                                         (@clientIDs ? (' join users u on u.uid = aus.payer_uid ') : ''),
                                                         " where aus.payment_sum < 1000 ", (@clientIDs ? (and => { "u.ClientID" => \@clientIDs} ) : ''),
                                                         " and wc.autopay_mode != 'none'"]);

    $log->out("Find " . scalar(@$wallets_for_update) . " wallets for update") if scalar(@$wallets_for_update) > 0;
    my @wallet_cids;
    for my $wallet (@$wallets_for_update){
        push @wallet_cids, $wallet->{wallet_cid};
        $log->out("Try to disable autopay " . $wallet->{wallet_cid} . " with sum " . $wallet->{payment_sum});
    }
    my $rows_affected = do_sql(PPC(shard => $shard), ["update wallet_campaigns wc
                                     join autopay_settings aus using (wallet_cid)
                                     set wc.autopay_mode = 'none'",
                                     where => {
                                        'wc.wallet_cid' => \@wallet_cids
                                     },
                                     "and aus.payment_sum < 1000"]);

    if(scalar($rows_affected) > 0){
        $log->out("Successful update of disable autopayment");
        $log->out("done: @{[int($rows_affected)]} rows affected");
        push @changed_wallet_ids, @wallet_cids;
    }
}

if (scalar(@changed_wallet_ids) > 0) {
    my $wallet_ids_stopped_autopay_by_script = join(',', @changed_wallet_ids);
    my $rows = do_sql(PPCDICT, "insert into ppc_properties (name, value) values ('wallet_ids_stopped_autopay_by_script', ?)
                                on duplicate key update value=CONCAT(value,',',?)",
                                $wallet_ids_stopped_autopay_by_script, $wallet_ids_stopped_autopay_by_script);
    if (scalar($rows) > 0) {
        $log->out("Add to ppcdict.properties @{[int(@changed_wallet_ids)]} wallet_ids stopped by script");
    }
}
