#!/usr/bin/env perl

=head1 DESCRIPTION

Выгрузка нерезидентов
https://st.yandex-team.ru/DIRECT-67103

=cut

use my_inc '../..';
use Direct::Modern;

use Yandex::DBTools;
use Yandex::CSV;
use List::MoreUtils qw/uniq/;

use Settings;
use ScriptHelper;


$log->out('START');


my $clients = get_all_sql(PPC(shard => 'all'), [
        'SELECT cl.ClientID, login, client_nds.nds as client_nds,
            group_concat(DISTINCT AgencyID) agency_id,
            active_28days_sum_rub
        FROM clients cl
        JOIN clients_options clo USING(ClientID)
        LEFT JOIN client_nds USING(ClientID)
        LEFT JOIN clients_stat USING(ClientID)
        LEFT JOIN users u ON u.uid=cl.chief_uid
        LEFT JOIN campaigns c using(uid)',
        WHERE => {
            non_resident => 1,
            date_from__le__dont_quote => 'now()',
            date_to__ge__dont_quote => 'now()',
            AgencyID__gt => 0,
            'clients_stat.type' => 'client',
        },
        'GROUP BY cl.ClientID',
    ]);

my @agency_ids = uniq map {$_->{agency_id}} @$clients;

my $agencies = get_hashes_hash_sql(PPC(shard => 'all'), [
        'SELECT cl.ClientID, login, nds,
            IFNULL(primary_manager_uid, IFNULL(primary_bayan_manager_uid, primary_geo_manager_uid)) as manager_uid
        FROM clients cl
        LEFT JOIN agency_nds USING(ClientID)
        LEFT JOIN users u ON u.uid=cl.chief_uid',
        WHERE => {
            'cl.ClientID' => \@agency_ids,
            date_from__le__dont_quote => 'now()',
            date_to__ge__dont_quote => 'now()',
        },
    ]);

my @manager_uids = uniq map {$_->{manager_uid}} values %$agencies;

my $managers = get_hashes_hash_sql(PPC(shard => 'all'), [
        'SELECT uid, fio FROM users',
        WHERE => {
            uid => \@manager_uids,
        },
    ]);

for my $client (@$clients) {
    my $agency = $agencies->{$client->{agency_id}};
    $client->{agency_login} = $agency->{login};
    $client->{agency_nds} = $agency->{nds};
    $client->{manager} = $managers->{$agency->{manager_uid}}->{fio};
}


data2csv($clients, {
        output_file => 'non-residents.csv',
        header_row => [qw/ ClientID login client_nds agency_login agency_nds manager active_28days_sum_rub /],
    },
);


$log->out('FINISH');
