#!/usr/bin/perl

use Direct::Modern;

use Yandex::DBShards;
use Yandex::DBTools;

use my_inc '../..', for => 'protected';
use BS::ResyncQueue;
use ScriptHelper 'Yandex::Log' => [ date_suf => '%Y%m%d', auto_rotate => 1, tee => $ENV{LOG_TEE}, lock => 1 ];
use Settings;
use ShardingTools;

my $CHUNK_SIZE = 1000;

my $BID_ARG;
my $DRY_RUN;

extract_script_params(
    'dry-run' => \$DRY_RUN,
    'bid=i' => \$BID_ARG
);

$log->out('start');

foreach_shard_parallel shard => [ ppc_shards() ], sub {
    my ($shard) = @_;
    do_shard($shard);
};

$log->out('finish');

sub do_shard {
    my ($shard) = @_;

    my $db = PPC( shard => $shard );
    my $shard_prefix_guard = $log->msg_prefix_guard("shard=$shard");
    $log->out('start');

    my $resource_id_floor = 0;
    while (1) {
        my $b_resources = get_all_sql($db, [
            'select br.resource_id, b.bid, b.cid from banners b join banners_performance bp using(bid) join banner_resources br using(bid)',
            ( $resource_id_floor || $BID_ARG ? (
                where => {
                    ( $resource_id_floor ? ( 'br.resource_id__gt' => $resource_id_floor ) : () ),
                    ( $BID_ARG ? ( 'b.bid' => $BID_ARG) : () ),
                }) : () ),
            "ORDER BY br.resource_id",
            "LIMIT $CHUNK_SIZE"
        ]);

        if(!@$b_resources) {
            $log->out('no more resources for deleting.. ending');
            last;
        }
        $log->out('got resources for deletion: ' .scalar(@$b_resources));

        $resource_id_floor = $b_resources->[-1]->{'resource_id'};

        $log->out("last resource_id: $resource_id_floor");

        delete_banner_resources_in_shard($db, $b_resources);
    }

    $log->out('finish');
}

sub delete_banner_resources_in_shard {
    my ($db, $resource_rows) = @_;
    $log->out( { deleting_resources => $resource_rows} );

    if(!$DRY_RUN) {
        my $result = do_delete_from_table($db, "banner_resources", where => { resource_id => [map { $_->{resource_id} } @$resource_rows] }) + 0;
        $log->out( { deleted_rows  => $result } );
    }

    my $resync_data = [ map { { cid => $_->{cid}, pid => 0, bid => $_->{bid}, priority => BS::ResyncQueue::PRIORITY_ONE_SHOT_RESYNC_BANNERS_ON_BR_FIX} } @$resource_rows];
    $log->out( { resync_data => $resync_data } );
    bs_resync($resync_data) unless $DRY_RUN;
}

