#!/usr/bin/perl

# $Id$

use warnings;
use strict;
no warnings 'redefine';
use Test::More;
use Test::Deep;

use POSIX qw/strftime/;

use Common qw/%MODERATE_STATUS/;
use Settings;
use Yandex::I18n;
use Yandex::TimeCommon;

use utf8;
use open ':std' => ':utf8';
binmode(STDERR, ":utf8");
binmode(STDOUT, ":utf8");
use Yandex::Test::UTF8Builder;

*Common::has_camp_active_banners = sub { return $_[0] % 2; };
*Common::old_CalcCampStatus = sub {
    my $camp = shift;
    my $sum_last = round2s( $camp->{sum} - $camp->{sum_spent} );

    my $status;
    if ( strftime("%Y%m%d", localtime) + 0 < substr($camp->{start_time}, 0, 8) + 0 && $camp->{statusModerate} ne 'New' ) {
        $status = iget("Начало %s", substr($camp->{start_time}, 6, 2) . '.' .
                                    substr($camp->{start_time}, 4, 2) . '.' .
                                    substr($camp->{start_time}, 0, 4));
    } elsif ( $sum_last <= 0 && $camp->{OrderID} != 0 && $camp->{sum} > 0 ) {
        $status = iget("Средства на счету закончились");
    } elsif ( $sum_last > 0 && $camp->{statusShow} eq 'No' ) {
        $status = iget("Кампания остановлена");
    } elsif ( $sum_last > 0 && $camp->{statusShow} eq 'Yes' && ($camp->{statusModerate} eq 'Yes' || $camp->{statusActive} eq 'Yes')  && $camp->{statusPostModerate} ne 'Yes') {                   
        $status = TimeTarget::timetarget_status($camp->{timeTarget}, $camp->{timezone_id});
    } elsif ( $camp->{statusModerate} eq 'Yes' && $camp->{sum_to_pay} > 0 && $camp->{statusPostModerate} ne 'Yes') {
        $status = iget("Ждёт оплаты");
    } else {
        if ($camp->{statusModerate} eq 'Yes' && $camp->{statusPostModerate} eq 'Yes') {
            $status = iget($MODERATE_STATUS{'Sent'}); 
        } else {
            $status = iget($MODERATE_STATUS{ $camp->{statusModerate} });
        }
        if ( $camp->{sum_to_pay} > 0 ) {
            $status .= ". " . iget("Ждёт оплаты");
        }
    }
    
    # проверяем, совпадает ли statusActive(из БК) с тем что должно быть
    my $statusActive_new = $sum_last > 0.001 && $camp->{statusShow} eq 'Yes' ? 'Yes' : 'No';
    if ($sum_last > 0 
        && ( $camp->{statusBsSynced} ne 'Yes'
             || $camp->{statusActive} && $camp->{statusActive} ne $statusActive_new
             || check_mysql_date($camp->{stopTime}) && time - mysql2unix($camp->{stopTime}) < $Settings::TRANSFER_DELAY_AFTER_STOP
         )
        && $camp->{statusPostModerate} eq 'Accepted'
    ) {
        $status .= ". " . iget("Идет активизация");
    }

    return $status;
};


*ccs    = \&Common::CalcCampStatus;
*o_ccs  = \&Common::old_CalcCampStatus;


my @tests = ( 
    { 
        cid => 1,
        sum => 10,
        sum_spent => 8,
        start_time => strftime("%Y%m%d", localtime) - 10,
        statusModerate => 'Yes',
        OrderID => 1,
        statusShow => 'Yes',
        statusActive => 'Yes',
        statusPostModerate => 'Accepted',
        timeTarget => '1ABCDEFGHIJKLMNOPQRSTUVWX2ABCDEFGHIJKLMNOPQRSTUVWX3ABCDEFGHOPQRSTUVWX4ABCDEFGHIJOPQRSTUVWX5ABCDEFGHIJKLMNOPQRSTUVWX6ABCDEFGHIJKLMNOPQRSTUVWX7ABCDEFGHIJKLMNOPQRSTUVWX8',
        timezone_id => 131,
        sum_to_pay => 0,
        statusBsSynced => 'Yes',
        stopTime => undef,
    },
    { 
        cid => 1,
        sum => 10,
        sum_spent => 8,
        start_time => strftime("%Y%m%d", localtime) - 10,
        statusModerate => 'Yes',
        OrderID => 1,
        statusShow => 'Yes',
        statusActive => 'No',
        statusPostModerate => 'Accepted',
        timeTarget => '1ABCDEFGHIJKLMNOPQRSTUVWX2ABCDEFGHIJKLMNOPQRSTUVWX3ABCDEFGHOPQRSTUVWX4ABCDEFGHIJOPQRSTUVWX5ABCDEFGHIJKLMNOPQRSTUVWX6ABCDEFGHIJKLMNOPQRSTUVWX7ABCDEFGHIJKLMNOPQRSTUVWX8',
        timezone_id => 131,
        sum_to_pay => 0,
        statusBsSynced => 'No',
        stopTime => undef,
    },
    { 
        cid => 1,
        sum => 10,
        sum_spent => 10,
        start_time => strftime("%Y%m%d", localtime) - 10,
        statusModerate => 'Yes',
        OrderID => 1,
        statusShow => 'Yes',
        statusActive => 'No',
        statusPostModerate => 'Accepted',
        timeTarget => '1ABCDEFGHIJKLMNOPQRSTUVWX2ABCDEFGHIJKLMNOPQRSTUVWX3ABCDEFGHOPQRSTUVWX4ABCDEFGHIJOPQRSTUVWX5ABCDEFGHIJKLMNOPQRSTUVWX6ABCDEFGHIJKLMNOPQRSTUVWX7ABCDEFGHIJKLMNOPQRSTUVWX8',
        timezone_id => 131,
        sum_to_pay => 0,
        statusBsSynced => 'No',
        stopTime => undef,
    },
    { 
        cid => 1,
        sum => 10,
        sum_spent => 1,
        start_time => strftime("%Y%m%d", localtime) - 10,
        statusModerate => 'Yes',
        OrderID => 1,
        statusShow => 'No',
        statusActive => 'No',
        statusPostModerate => 'Accepted',
        timeTarget => '1ABCDEFGHIJKLMNOPQRSTUVWX2ABCDEFGHIJKLMNOPQRSTUVWX3ABCDEFGHOPQRSTUVWX4ABCDEFGHIJOPQRSTUVWX5ABCDEFGHIJKLMNOPQRSTUVWX6ABCDEFGHIJKLMNOPQRSTUVWX7ABCDEFGHIJKLMNOPQRSTUVWX8',
        timezone_id => 131,
        sum_to_pay => 0,
        statusBsSynced => 'Yes',
        stopTime => undef,
    },
    { 
        cid => 1,
        sum => 10,
        sum_spent => 1,
        start_time => strftime("%Y%m%d", localtime) - 10,
        statusModerate => 'Yes',
        OrderID => 1,
        statusShow => 'No',
        statusActive => 'Yes',
        statusPostModerate => 'Accepted',
        timeTarget => '1ABCDEFGHIJKLMNOPQRSTUVWX2ABCDEFGHIJKLMNOPQRSTUVWX3ABCDEFGHOPQRSTUVWX4ABCDEFGHIJOPQRSTUVWX5ABCDEFGHIJKLMNOPQRSTUVWX6ABCDEFGHIJKLMNOPQRSTUVWX7ABCDEFGHIJKLMNOPQRSTUVWX8',
        timezone_id => 131,
        sum_to_pay => 0,
        statusBsSynced => 'No',
        stopTime => undef,
    },
    { 
        cid => 1,
        sum => 0,
        sum_spent => 0,
        start_time => strftime("%Y%m%d", localtime) - 10,
        statusModerate => 'Yes',
        OrderID => 1,
        statusShow => 'Yes',
        statusActive => 'No',
        statusPostModerate => 'Accepted',
        timeTarget => '1ABCDEFGHIJKLMNOPQRSTUVWX2ABCDEFGHIJKLMNOPQRSTUVWX3ABCDEFGHOPQRSTUVWX4ABCDEFGHIJOPQRSTUVWX5ABCDEFGHIJKLMNOPQRSTUVWX6ABCDEFGHIJKLMNOPQRSTUVWX7ABCDEFGHIJKLMNOPQRSTUVWX8',
        timezone_id => 131,
        sum_to_pay => 0,
        statusBsSynced => 'No',
        stopTime => undef,
    },
    { 
        cid => 1,
        sum => 0,
        sum_spent => 0,
        start_time => strftime("%Y%m%d", localtime) - 10,
        statusModerate => 'New',
        OrderID => 1,
        statusShow => 'Yes',
        statusActive => 'No',
        statusPostModerate => 'New',
        timeTarget => '1ABCDEFGHIJKLMNOPQRSTUVWX2ABCDEFGHIJKLMNOPQRSTUVWX3ABCDEFGHOPQRSTUVWX4ABCDEFGHIJOPQRSTUVWX5ABCDEFGHIJKLMNOPQRSTUVWX6ABCDEFGHIJKLMNOPQRSTUVWX7ABCDEFGHIJKLMNOPQRSTUVWX8',
        timezone_id => 131,
        sum_to_pay => 10,
        statusBsSynced => 'No',
        stopTime => undef,
    },
    { 
        cid => 1,
        sum => 0,
        sum_spent => 0,
        start_time => strftime("%Y%m%d", localtime) - 10,
        statusModerate => 'Yes',
        OrderID => 1,
        statusShow => 'Yes',
        statusActive => 'No',
        statusPostModerate => 'Yes',
        timeTarget => '1ABCDEFGHIJKLMNOPQRSTUVWX2ABCDEFGHIJKLMNOPQRSTUVWX3ABCDEFGHOPQRSTUVWX4ABCDEFGHIJOPQRSTUVWX5ABCDEFGHIJKLMNOPQRSTUVWX6ABCDEFGHIJKLMNOPQRSTUVWX7ABCDEFGHIJKLMNOPQRSTUVWX8',
        timezone_id => 131,
        sum_to_pay => 10,
        statusBsSynced => 'No',
        stopTime => undef,
    },
    { 
        cid => 1,
        sum => 0,
        sum_spent => 0,
        start_time => strftime("%Y%m%d", localtime) - 10,
        statusModerate => 'Yes',
        OrderID => 1,
        statusShow => 'Yes',
        statusActive => 'No',
        statusPostModerate => 'Accepted',
        timeTarget => '1ABCDEFGHIJKLMNOPQRSTUVWX2ABCDEFGHIJKLMNOPQRSTUVWX3ABCDEFGHOPQRSTUVWX4ABCDEFGHIJOPQRSTUVWX5ABCDEFGHIJKLMNOPQRSTUVWX6ABCDEFGHIJKLMNOPQRSTUVWX7ABCDEFGHIJKLMNOPQRSTUVWX8',
        timezone_id => 131,
        sum_to_pay => 10,
        statusBsSynced => 'No',
        stopTime => undef,
    },
    { 
        cid => 1,
        sum => 10,
        sum_spent => 8,
        start_time => strftime("%Y%m%d", localtime) + 0,
        statusModerate => 'Yes',
        OrderID => 1,
        statusShow => 'Yes',
        statusActive => 'No',
        statusPostModerate => 'Yes',
        timeTarget => '1ABCDEFGHIJKLMNOPQRSTUVWX2ABCDEFGHIJKLMNOPQRSTUVWX3ABCDEFGHOPQRSTUVWX4ABCDEFGHIJOPQRSTUVWX5ABCDEFGHIJKLMNOPQRSTUVWX6ABCDEFGHIJKLMNOPQRSTUVWX7ABCDEFGHIJKLMNOPQRSTUVWX8',
        timezone_id => 131,
        sum_to_pay => 0,
        statusBsSynced => 'No',
        stopTime => unix2mysql(time - $Settings::TRANSFER_DELAY_AFTER_STOP + 10),
    },
    { 
        cid => 1,
        sum => 10,
        sum_spent => 8,
        start_time => strftime("%Y%m%d", localtime) + 0,
        statusModerate => 'No',
        OrderID => 1,
        statusShow => 'Yes',
        statusActive => 'No',
        statusPostModerate => 'Yes',
        timeTarget => '1ABCDEFGHIJKLMNOPQRSTUVWX2ABCDEFGHIJKLMNOPQRSTUVWX3ABCDEFGHOPQRSTUVWX4ABCDEFGHIJOPQRSTUVWX5ABCDEFGHIJKLMNOPQRSTUVWX6ABCDEFGHIJKLMNOPQRSTUVWX7ABCDEFGHIJKLMNOPQRSTUVWX8',
        timezone_id => 131,
        sum_to_pay => 0,
        statusBsSynced => 'No',
        stopTime => unix2mysql(time - $Settings::TRANSFER_DELAY_AFTER_STOP + 10),
    },
    { 
        cid => 1,
        sum => 10,
        sum_spent => 8,
        start_time => strftime("%Y%m%d", localtime) + 0,
        statusModerate => 'No',
        OrderID => 1,
        statusShow => 'Yes',
        statusActive => 'No',
        statusPostModerate => 'Yes',
        timeTarget => '1ABCDEFGHIJKLMNOPQRSTUVWX2ABCDEFGHIJKLMNOPQRSTUVWX3ABCDEFGHOPQRSTUVWX4ABCDEFGHIJOPQRSTUVWX5ABCDEFGHIJKLMNOPQRSTUVWX6ABCDEFGHIJKLMNOPQRSTUVWX7ABCDEFGHIJKLMNOPQRSTUVWX8',
        timezone_id => 131,
        sum_to_pay => 10,
        statusBsSynced => 'No',
        stopTime => unix2mysql(time - $Settings::TRANSFER_DELAY_AFTER_STOP + 10),
    },
);

Test::More::plan(tests => scalar(@tests));

my $base_result = {
    wait_start        => undef,
    money_finished    => undef,
    stopped           => undef,
    timetarget        => undef,
    moderate          => undef,
    sum_to_pay        => undef,
    activation        => undef,
    no_active_banners => undef,
};
for my $t (@tests) {
    my %base = %$base_result;
    cmp_deeply(ccs($t), o_ccs($t));
}

print ">>>!!! 11 and 12 are not ok, but that's ok\n";
