#!/usr/bin/perl

=head1 NAME

=head1 DESCRIPTION

Удаляет записи из таблички banner_permalinks по bid.
Применяется для DIRECT-108372, так как какое-то время удаление из banner_permalinks при удалении баннера не работало

Формат файла - построчно "bid shard"

=cut

use my_inc '../..';

use Direct::Modern;

use Settings;
use ScriptHelper;
use ShardingTools;

use Path::Tiny;

use Yandex::DBTools;
use Yandex::DBShards;
use Yandex::Retry;
use Yandex::ListUtils;

my $SLEEP_COEF = 0.2;
my $CHUNK_SIZE = 10_000;

$log->out('START');

my $ONLY_SHARD;
my $ONLY_BID;
my $BIDS_FILE;

extract_script_params(
    'only-shard=i' => \$ONLY_SHARD,
    'only-bid=i'  => \$ONLY_BID,
    'bids-file=s' => \$BIDS_FILE,
);

my $bids_by_shard = {};
if ($ONLY_BID && $ONLY_SHARD) {
    $bids_by_shard->{$ONLY_SHARD} = [ $ONLY_BID ];
} elsif ($BIDS_FILE) {
    my $data = path($BIDS_FILE)->slurp;
    foreach my $row (split /\n/, $data) {
        if ($row =~ /^(\d+)\s+(\d+)$/) {
            push @{$bids_by_shard->{$2}}, $1;
        } else {
            $log->out("Invalid row: $row");
        }
    }
} else {
    die "Bids file or single bid should be specified";
}

foreach_shard_parallel_verbose($log, sub {
    my ($shard) = @_;

    my $shard_removed = 0;
    my $bids = $bids_by_shard->{$shard} // [];
    for my $chunk (chunks($bids, $CHUNK_SIZE)) {
        my $relax_guard = relaxed_guard(times => $SLEEP_COEF);

        $shard_removed += do_delete_from_table(PPC(shard => $shard), "banner_permalinks",
            where => {
                'bid__in' => $chunk,
            });
    }

    $log->out("Removed $shard_removed records of " . scalar @$bids);
});

$log->out('FINISH');
