#!/usr/bin/perl

=head1 NAME

=head1 DESCRIPTION

Меняет язык регион клиента на переданный в файле. Меняет регион только в случае если он не указан (в базе 0).
Применяется для DIRECT-109277

=cut

use my_inc '../..';

use Direct::Modern;

use List::Util qw(min);
use Settings;
use ScriptHelper;

use Path::Tiny;

use Yandex::DBTools;
use Yandex::DBShards;
use Yandex::Retry;

my $SLEEP_COEF = 0.2;
my $CHUNK_SIZE = 1_000;

$log->out('START');

my $ONLY_CLIENT;
my $ONLY_LANG;
my $CLIENTS_FILE;

extract_script_params(
    'only-client=i'  => \$ONLY_CLIENT,
    'only-lang=i'  => \$ONLY_LANG,
    'clients-file=s' => \$CLIENTS_FILE,
);

my $lang_by_client_id = {};
if ($ONLY_CLIENT && $ONLY_LANG) {
    $lang_by_client_id = { $ONLY_CLIENT => $ONLY_LANG };
} elsif ($CLIENTS_FILE) {
    my $data = path($CLIENTS_FILE)->slurp;
    foreach my $row (split /\n/, $data) {
        if ($row =~ /^(\d+)\s+(\d+)$/) {
            $lang_by_client_id->{$2} = $1;
        } else {
            $log->out("Invalid row: $row, expected format: COUNTRY<Tab>CLIENT_ID");
        }
    }
} else {
    die "Should either provide file or a single client-language pair";
}

my $total_records_updated = 0;
foreach_shard ClientID => [keys %$lang_by_client_id], chunk_size => $CHUNK_SIZE, with_undef_shard => 1, sub {
    my ($shard, $clients_chunk) = @_;
    if (!$shard) {
        $log->out("Cant find shard for clients:", $clients_chunk);
        return;
    }

    my $relax_guard = relaxed_guard(times => $SLEEP_COEF);

    $total_records_updated += do_update_table(PPC(shard => $shard), "clients",
        {
            country_region_id__dont_quote => sql_case('ClientID', { map { $_ => $lang_by_client_id->{$_} } @$clients_chunk }),
        },
        where => {
            'ClientID__in'      => $clients_chunk,
            'country_region_id' => 0,
        });
};

$log->out("Updated $total_records_updated records");

$log->out('FINISH');
