#!/usr/bin/perl
use my_inc '../..';

use Direct::Modern;

use List::Util qw(min);
use Settings;
use ScriptHelper;

use Path::Tiny;

use Yandex::DBTools;
use Yandex::DBShards;
use Yandex::Retry;

my $SLEEP_COEF = 0.2;
my $CHUNK_SIZE = 10_000;

$log->out('START');

my $ONLY_BID;
my $FROM_LANGS;
my $BIDS_FILE;

extract_script_params(
    'only-bid=i' => \$ONLY_BID,
    'from-langs=s' => \$FROM_LANGS,
    'bids-file=s' => \$BIDS_FILE,
);

my @from_langs_cond = split(',', $FROM_LANGS);
if (!@from_langs_cond) {
    die("Should specify languages")
}

push @from_langs_cond, '';

my $bids = [];
if ($ONLY_BID) {
    $bids = [$ONLY_BID];
} else {
    my $data = path($BIDS_FILE)->slurp;
    foreach my $row (split /\n/, $data) {
        if ($row =~ /^\d+$/) {
            push @$bids, $row;
        } else {
            $log->out("Invalid row: $row");
        }
    }
}

my $total_fixed_cnt = 0;
foreach_shard bid => $bids, chunk_size => $CHUNK_SIZE, with_undef_shard => 1, sub {
    my ($shard, $bids_chunk) = @_;
    if (!$shard) {
        $log->out("Cant find shard for bids:", $bids_chunk);
        return;
    }

    my $relax_guard = relaxed_guard(times => $SLEEP_COEF);

    $total_fixed_cnt += do_update_table(PPC(shard => $shard), "banners", {
        'language' => 'unknown',
    }, where => {
        'language__in' => \@from_langs_cond,
        'bid__in' => $bids_chunk,
    });
    $log->out("Processed banners with bids:", join(',', @$bids_chunk));
};

$log->out("Fixed total $total_fixed_cnt banners");

$log->msg_prefix('');

$log->out('FINISH');
