#!/usr/bin/perl

use my_inc "../..";


=head1 DESCRIPTION

    Выгружаем менеджеров для списка нехороших баннеров

    На входе текстовый файл со списком bid-ов баннеров

=cut

use 5.010;
use strict;
use warnings;
use autodie;

use lib::abs '..';

use Settings;
use ScriptHelper;

use Yandex::DBTools;
use Yandex::ListUtils;
use List::MoreUtils qw/ uniq /;
use Yandex::CSV;

use utf8;



our $DEBUG = 0 || $ENV{DEBUG};
our $chunk_size = 2000;


$log->out('START');

$log->out('loading banner list');
my @bids;
while (my $line = <>) {
    chomp $line;
    push @bids, $line;
    last if $DEBUG && state $cnt++ >= 10000;
}

@bids = sort {$a<=>$b} @bids;

$log->out(sprintf 'fetching banners from db, %i chunks', scalar @bids / $chunk_size);
my %stat;
for my $chunk ( chunks \@bids, $chunk_size ) {
    $log->out("chunk #" . ++(state $chunk_num)); 
    my $page = get_all_sql( PPC(shard => 'all'), [
            'SELECT bid, cid, c.uid, AgencyUID, ManagerUID
            FROM banners b
            JOIN campaigns c USING(cid)',
            WHERE => {
#                cid => 6040798,
                bid => $chunk,
                'b.statusActive' => 'Yes',
                'c.statusActive' => 'Yes',
            },
        ]);

    for my $item ( @$page ) {
        my $stat_uid = $stat{$item->{uid}} //= {};
        if ($stat_uid->{$item->{cid}}) {
            $stat_uid->{$item->{cid}} .= q{,} . $item->{bid};
        }
        else {
            $stat_uid->{$item->{cid}} = $item->{bid};
        }

        $stat_uid->{managers}->{$item->{ManagerUID}} = 1  if $item->{ManagerUID};
        $stat_uid->{agencies}->{$item->{AgencyUID}} = 1  if $item->{AgencyUID};
    }

#    last;
    sleep 1;
}


$log->out('fetching logins');

my @agency_uids =
    uniq
    map {(keys %{ $stat{$_}->{agencies} })}
    grep {$stat{$_}->{agencies}}
    keys %stat;

my $manager = get_hash_sql(PPC(shard=>'all'), [
        'SELECT uid, primary_manager_uid
        FROM users u
        JOIN clients c USING(ClientID)',
        WHERE => { uid => \@agency_uids },
    ]);


my @uids = uniq(
    (keys %stat),
    (
        map {keys %{ $stat{$_}->{managers} }}
        grep {$stat{$_}->{managers}}
        keys %stat
    ),
    (
        map {keys %{ $stat{$_}->{agencies} }}
        grep {$stat{$_}->{agencies}}
        keys %stat
    ),
    values %$manager,
);


my $users = get_hashes_hash_sql(PPC(shard=>'all'), [
        'SELECT uid, login, email FROM users',
        WHERE => { uid => \@uids },
    ]);
my $login = { map {($_ => $users->{$_}->{login})} keys %$users };

$log->out('writing table');

my (@stat_a, @stat_m, @stat_c);

#say join qq{\t}, qw/ agency manager user cid bids/;

for my $uid ( sort {$a<=>$b} keys %stat ) {
    my $item = $stat{$uid};
    my $user = $users->{$uid};

    if ( $item->{agencies} ) {
        for my $cid ( keys %$item ) {
            next if $cid !~ /^\d+$/xms;

            my $agencies = join( q{,}, uniq grep {$_} map {$login->{$_}} sort {$a<=>$b} keys %{$item->{agencies}} );
            my $managers = join( q{,}, uniq grep {$_} map {$login->{$_}} sort {$a<=>$b} map {$manager->{$_}} keys %{$item->{agencies}} );

            push @stat_a, [ $agencies, $managers, $user->{login}, $cid, $item->{$cid} ];
        }
    }

    if ( $item->{managers} ) {
        for my $cid ( keys %$item ) {
            next if $cid !~ /^\d+$/xms;

            my $managers = join( q{,}, map {$login->{$_}} sort {$a<=>$b} keys %{$item->{managers}} );
            push @stat_m, [ $managers, $user->{login}, $cid, $item->{$cid} ];
        }
    }

    if ( !$item->{agencies} && !$item->{managers} ) {
        for my $cid ( keys %$item ) {
            next if $cid !~ /^\d+$/xms;

            push @stat_c, [ $user->{login}, $user->{email}, $cid, $item->{$cid} ];
        }
    }
}

data2csv(\@stat_m, { bom_header => 1, output_file => 'managers.csv', header_row => [qw/ manager user cid bids/] });
data2csv(\@stat_a, { bom_header => 1, output_file => 'agencies.csv', header_row => [qw/ agency manager user cid bids/] });
data2csv(\@stat_c, { bom_header => 1, output_file => 'clients.csv', header_row => [qw/ user login cid bids/] });


$log->out('FINISH');


