#!/usr/bin/perl

use Direct::Modern;
use my_inc "../..";

use Settings;
use ScriptHelper;

use Yandex::DBTools;
use Yandex::DBShards;
use Yandex::CSV;
use Yandex::Clickhouse;
use List::MoreUtils qw/uniq/;

extract_script_params(
    'from=s' => \my $date_from,
    'to=s' => \my $date_to,
);

my $clh = Yandex::Clickhouse->new(
    host => 'ppchouse01e.yandex.ru',
);
$clh->query_format('TabSeparatedWithNames');

my $logs = $clh->query(
    "select distinct cluid, log_date
    from ppclog_cmd
    where
        log_date >= toDate('$date_from')
    and log_date <= toDate('$date_to')
    and cmd = 'showCamp'
    and role = 'support'
    order by log_date
")->tsv(names => 1);
my @uids = grep { /^\d+$/ } uniq map { /^\[(.+?)\]$/ && split /\D+/, $1 } map { $_->{cluid} } @$logs;

my $user_info =
    get_hashes_hash_sql(PPC(uid => \@uids), [
            'select uid, login, ClientID, email from users',
            where => { uid => SHARD_IDS },
        ]);

for my $row (@$logs) {
    my $cluid = delete $row->{cluid};
    $cluid =~ s!\D!!g;
    $row->{ClientID} = $user_info->{$cluid}->{ClientID} // '<unknown>';
    $row->{login} = $user_info->{$cluid}->{login} // '<unknown>';
}
data2csv($logs, { output_file => 'supported_users.csv', header_row => [qw/login ClientID log_date/]});

