#!/usr/bin/perl

use my_inc "../..";


=head1

	Удаляет ставки по фразам, не привязанным ни к одной кампании
	Опиционалые параметры:
        --cid - кампании для обработки, можно диапазоны. по умолчанию - все

=cut 

use 5.010;
use strict;
use warnings;
use utf8;

use Settings;
use ScriptHelper;

use Yandex::DBTools;
use ShardingTools;

use JSON;
use List::Util qw/ max /;


my $CHUNK_SIZE = 10000;


my $cid_str;
my $SLEEP_COEF = 1;
extract_script_params(
    'cid|cids=s' => \$cid_str,
    "sleep-coef=i" => \$SLEEP_COEF,
);

my $cid_start = 0;
my $cid_end = max @{ get_one_column_sql(PPC(shard=>'all'), 'select max(cid) from campaigns') };
if ( $cid_str && (my ($from, $is_range, $to) = $cid_str =~ / ^ (\d+) (?: (- | \.\.) (\d+)? )? /xms) ) {
    $cid_start = $from;
    $cid_end   = $is_range ? $to || $cid_end : $from;
}

$log->out("START for cids $cid_start-$cid_end");

my $i_cid = $cid_start;
while ($i_cid <= $cid_end) {
    my $st = time;

    my $j_cid = $i_cid + $CHUNK_SIZE - 1;
    $log->out("checking cids #$i_cid .. #$j_cid");

    for my $shard (ppc_shards()) {
        my $cids =
            get_one_column_sql( PPC(shard => $shard), [
                'SELECT DISTINCT bi.cid
                FROM bids bi
                LEFT JOIN campaigns c USING(cid)',
                WHERE => {
                    'c.cid__is_null' => 1,
                    'bi.cid__between' => [$i_cid, $j_cid],
                },
            ]);
        if (@$cids) {
            $log->out("shard #$shard: found lost bids for campaigns " . to_json($cids));
            for my $cid (@$cids) {
                $log->out("cleaning up cid #$cid");
                do_delete_from_table(PPC(shard => $shard), 'bids', where => {cid => $cid});
                do_delete_from_table(PPC(shard => $shard), 'bids_base', where => {cid => $cid, bid_type => 'keyword'});
            }
        }
    }

    $i_cid += $CHUNK_SIZE;

    if (my $pause = $SLEEP_COEF * (time - $st)) {
        $log->out(sprintf "sleep %f", $pause);
        sleep $pause;
    }
}

$log->out('FINISH');


