#!/usr/bin/perl

=head1 DEPLOY

    Скрипт актуализирует данные о регионах в креативах.
    Важно смотреть логи скрипта.
    В конце он пишет насколько успешно он отработал. Возможны ситуации, когда отвалился BannerStorage или за время обработки креатива его данные уже сменились.
    В этом случае мы не перезаписываем, но пишем в логи, что произошла ошибка в шарде.
    RESULT: NO PROBLEMS WITH SHARD <номер шарда>, PLEASE RELAX! - значит скрипт на шарде отработал без проблем.
    RESULT: RESULT: NEED RESTART SCRIPT FOR SHARD <номер шарда> - значит в шарде произошли сбои и надо перезапустить скрипт с этим шардом.

    Параметры входной строки:
        --shards - номера шардов на которых надо запустить скрипт, через запятую.

=head1 RUNNING

    perl ./protected/one-shot/DIRECT-54960-creatives_geo.pl
    perl ./protected/one-shot/DIRECT-54960-creatives_geo.pl --shards=8,7

=cut


use Direct::Modern;

use my_inc "../..";

use List::MoreUtils qw/uniq none/;

use Yandex::DBTools;
use Yandex::Retry qw/relaxed/;

use ScriptHelper;
use Settings;
use ShardingTools qw/ppc_shards foreach_shard_parallel_verbose/;
use GeoTools;
use BannerStorage;
my $SLEEP_TIME_COEF = 1;

my $SHARDS = "";
extract_script_params(
    "shards=s" => \$SHARDS,
);

$log->out('START');
if ($SHARDS) {
    my %shards = map {$_ => 1} split /\s*,\s*/, $SHARDS;
    foreach my $shard (keys %shards) {
        die 'Anavailable shard number, please check!' if none {$shard == $_} ppc_shards();
    }
    foreach_shard_parallel_verbose($log, sub {
        my $shard = shift;
        my $msg_prefix_guard = $log->msg_prefix_guard("[shard_$shard]");
        check_shard_creatives($shard) if ($shards{$shard});
    });
} else {
    foreach_shard_parallel_verbose($log, sub {
        my $shard = shift;
        check_shard_creatives($shard);
    });
}
$log->out('FINISH');

sub check_shard_creatives {
    my $shard = shift;
    my $perf_creatives = [];
    my $last_perf_creative_id = 0;
    my $shard_has_problem = 0;

    my $max_perf_creative_id = get_one_field_sql(PPC(shard => $shard), "SELECT MAX(creative_id) FROM perf_creatives");
    do {
        relaxed times => $SLEEP_TIME_COEF, sub {
            $log->out('Fetching perf_creative chunk to fix');
            $perf_creatives = get_all_sql(PPC(shard => $shard), 
                'SELECT creative_id, sum_geo, ClientID FROM perf_creatives WHERE creative_id >? AND creative_id <= ? ORDER BY creative_id LIMIT ?', $last_perf_creative_id, $max_perf_creative_id, 100);
            my $perf_creatives_cnt = scalar @$perf_creatives;
            $log->out("Got $perf_creatives_cnt creatives to check and fix");

            if ($perf_creatives_cnt) {

                $last_perf_creative_id = $perf_creatives->[-1]->{creative_id};
                my %client_ids = map {$_->{creative_id} => $_->{ClientID}} @$perf_creatives;
                my $creative_id_geos = {};

                my $get_adgroups_creative_geo = get_all_sql(PPC(shard => $shard), ["SELECT geo, creative_id FROM phrases p
                    JOIN banners_performance bp ON bp.pid=p.pid",
                    where => {'creative_id'=> [map { $_->{creative_id} } @$perf_creatives]}]);
                foreach (@$get_adgroups_creative_geo) {
                    push @{$creative_id_geos->{$_->{creative_id}}}, $_->{geo};
                }

                my %adgroups_creative_id_geo_str_hash = map {my $translocal_opt = {ClientID => $client_ids{$_}};
                                                          $_ => GeoTools::moderation_countries(
                                                                    GeoTools::get_targetings_union([ uniq @{$creative_id_geos->{$_}}], $translocal_opt), $translocal_opt)}
                                                     keys %$creative_id_geos;
                my %case_values;
                foreach my $perf_creative (@$perf_creatives) {
                    next unless defined $adgroups_creative_id_geo_str_hash{$perf_creative->{creative_id}};
                    if (($perf_creative->{sum_geo} || '') ne $adgroups_creative_id_geo_str_hash{$perf_creative->{creative_id}}) {
                        $case_values{$perf_creative->{creative_id}}->{sum_geo} = $adgroups_creative_id_geo_str_hash{$perf_creative->{creative_id}};
                    }
                }
                if (%case_values) {
                    eval {
                        BannerStorage::update_geo_on_creatives({map {$_ => $case_values{$_}->{sum_geo}} keys %case_values});
                    };
                    if ($@) {
                        $shard_has_problem = 1;
                    }
                    $log->out(sprintf("BannersStorage update: %d creatives", scalar(keys %case_values)));
                }
                do_in_transaction {
                    # Проверяем, что за время высчитывания данные в perf_creatives не поменялись для обрабатываемых креативов.
                    my $just_seleted_creatives = get_hash_sql(PPC(shard=>$shard), ['SELECT creative_id, sum_geo FROM perf_creatives',
                                                 where => {creative_id => [keys %case_values]},
                                                 "FOR UPDATE"]);
                    my $previosly_selected_creatives = [grep {$case_values{$_->{creative_id}}} @$perf_creatives];
                    if (grep {($_->{sum_geo} || '') ne ($just_seleted_creatives->{$_->{creative_id}} || '')} @$previosly_selected_creatives) {
                        $shard_has_problem = 1;
                    } else {
                        do_mass_update_sql(PPC(shard=>$shard), 'perf_creatives', creative_id => \%case_values);
                        foreach (keys %case_values) {
                            $log->out(sprintf("Updated creative %d: from: %s to: %s", $_, $just_seleted_creatives->{$_}, $case_values{$_}->{sum_geo}));
                        }
                    }
                };
            }
        };
    } while @$perf_creatives > 0;

    if ($shard_has_problem) {
        $log->out("RESULT: NEED RESTART SCRIPT FOR SHARD $shard");
    } else {
        $log->out("RESULT: NO PROBLEMS WITH SHARD $shard, PLEASE RELAX!");
    }

}
