#!/usr/bin/perl
use Direct::Modern;

use Try::Tiny;

use Yandex::DBTools;

use my_inc '../..';
use Settings;
use ScriptHelper 'Yandex::Log' => [ date_suf => '%Y%m%d', auto_rotate => 1, tee => $ENV{LOG_TEE}, lock => 1 ];
use Encode;
use JSON;

extract_script_params();

require Yandex::Clickhouse;
my $instance_config = get_db_config("ppchouse:logs");

my $ch = Yandex::Clickhouse->new(
    host => 'ppchouse.yandex.net',
    user => 'readonly',
    port => '8123',
    timeout => '3600',
    settings => {
        database => $instance_config->{db},
        max_query_size => 966899,
    },
);

my ($beta_num, $query_num, $range_name) = @ARGV;

my $YEAR = 2017;

my $REPLACE_DATE    = "--replace-date--";
my $DIR_BETA        = "";
my $OUT_DIR         = $DIR_BETA."drf-metrics/dump/$range_name";
my $FILES_EXT       = '.ch';

my $FILE_TXT_CMP    = $OUT_DIR . '/allTextCampaigns'              . $FILES_EXT;
my $FILE_OPT_NO     = $OUT_DIR . '/optionIsNo'                    . $FILES_EXT;
my $FILE_OPT_YES    = $OUT_DIR . '/optionIsYes'                   . $FILES_EXT;
my $FILE_SP_ON      = $OUT_DIR . '/settingsArePresentOptionIsNot' . $FILES_EXT;
my $FILE_BLK        = $OUT_DIR . '/block'                         . $FILES_EXT;
my $FILE_BLK_OR_OP_Y= $OUT_DIR . '/blockOrOptionsYes'             . $FILES_EXT;
my $FILE_DEF        = $OUT_DIR . '/noSettingsOnTextCampaign'      . $FILES_EXT;

sub getLoggingTime {
    my ($sec,$min,$hour,$mday,$mon,$ts_year,$wday,$yday,$isdst)=localtime(time);
    my $nice_timestamp = sprintf("%02d%02d%02d%02d",
                                   $mday,$hour,$min,$sec);
    return $nice_timestamp;
}

my $timestamp = getLoggingTime();
my $logfilename = "drf-log-$timestamp-$range_name";

sub LogInfo {
    my $log_string = getLoggingTime() . "\t$_[0]";
    print "$log_string";
    open(my $logfile, '>>', $logfilename)
        or die "Failed opening log file $logfilename $!\n\n";
    print $logfile "$log_string";
    close $logfile;
}

my $CH_QUERY_TXT_CMP = "
    SELECT distinct reqid, log_date, param
    FROM ppclog_api 
    WHERE (log_date = toDate('$REPLACE_DATE'))
      AND (cmd = 'campaigns.add')
      AND (param like '%TextCampaign%')
    FORMAT JSON
";

my $CH_QUERY_OPT_NO = "
    SELECT distinct reqid, log_date, param
    FROM ppclog_api 
    WHERE (log_date = toDate('$REPLACE_DATE'))
      AND (cmd = 'campaigns.add')
      AND ((param LIKE '%Value\":\"NO\",\"Option\":\"ENABLE_RELATED_KEYWORDS%')
        OR (param LIKE '%ENABLE_RELATED_KEYWORDS\",\"Value\":\"NO%'))
    FORMAT JSON
";

my $CH_QUERY_OPT_YES = "
    SELECT distinct reqid, log_date, param
    FROM ppclog_api 
    WHERE (log_date = toDate('$REPLACE_DATE'))
      AND (cmd = 'campaigns.add')
      AND ((param LIKE '%Value\":\"YES\",\"Option\":\"ENABLE_RELATED_KEYWORDS%')
        OR (param LIKE '%ENABLE_RELATED_KEYWORDS\",\"Value\":\"YES%'))
    FORMAT JSON
";

my $CH_QUERY_SP_ON = "
    SELECT distinct reqid, log_date, param
    FROM ppclog_api 
    WHERE (log_date = toDate('$REPLACE_DATE'))
      AND (cmd = 'campaigns.add')
      AND (param LIKE '%\"Settings\":%')
      AND (param NOT LIKE '%\"ENABLE_RELATED_KEYWORDS\":%')
    FORMAT JSON
";

my $CH_QUERY_BLK = "
    SELECT distinct reqid, log_date, param
    FROM ppclog_api 
    WHERE (log_date = toDate('$REPLACE_DATE'))
      AND (cmd = 'campaigns.add')
      AND (param LIKE '%\"RelevantKeywords\":%')
    FORMAT JSON
";

my $CH_QUERY_BLK_OR_OP_Y = "
    SELECT distinct reqid, log_date, param
    FROM ppclog_api 
    WHERE (log_date = toDate('$REPLACE_DATE'))
      AND (cmd = 'campaigns.add')
      AND ((param LIKE '%\"RelevantKeywords\":%')
        OR((param LIKE '%Value\":\"YES\",\"Option\":\"ENABLE_RELATED_KEYWORDS%')
          OR (param LIKE '%ENABLE_RELATED_KEYWORDS\",\"Value\":\"YES%')
          OR (param NOT LIKE '%ENABLE_RELATED_KEYWORDS%')))
    FORMAT JSON
";

my $CH_QUERY_DEF = "
    SELECT distinct reqid, log_date, param
    FROM ppclog_api
    WHERE (log_date = toDate('$REPLACE_DATE'))
      AND (cmd = 'campaigns.add')
      AND (param NOT LIKE '%\"Settings\":%')
      AND (param LIKE '%TextCampaign%')
    FORMAT JSON
";

my %file_for_query = (
    $CH_QUERY_TXT_CMP   ,  $FILE_TXT_CMP,
    $CH_QUERY_OPT_NO    ,  $FILE_OPT_NO,
    $CH_QUERY_OPT_YES   ,  $FILE_OPT_YES,
    $CH_QUERY_SP_ON     ,  $FILE_SP_ON,
    $CH_QUERY_BLK       ,  $FILE_BLK,
    $CH_QUERY_BLK_OR_OP_Y  ,  $FILE_BLK_OR_OP_Y,
    $CH_QUERY_DEF       ,  $FILE_DEF,
);

sub TwoDigits {
    my $td_in = $_[0];
    return $td_in < 10 ? '0'.$td_in : "$td_in";
}

sub BuildDatesRange {
    my $month = TwoDigits($_[0]);
    my @days = $_[1]..$_[2];
    
    my @range;
    foreach (@days) {
        my $day_i = TwoDigits($_);
        my $bdr_date_i = "$YEAR-$month-$day_i";
        push(@range, $bdr_date_i);
    }
    return @range;
}

sub BuildQuery {
   my $bq_query_template = $_[0];
   my $query_date = $_[1];
   my $result_query = $bq_query_template =~ s/'$REPLACE_DATE'/'$query_date'/r;
   return $result_query;
}

sub BuildFilename {
    my $bf_query_template = $_[0];
    my $date = $_[1];

    return $file_for_query{$bf_query_template} . "." . $date;
}

sub ExecuteQueryAndDumpToFile {

    my $query = $_[0];
    my $filename = $_[1];
    
    LogInfo("Executing query:\n$query\n");
    my $result= $ch->query($query);

    my @ch_data = @{$result->json->{data}};
    my $rows_total = $result->json->{rows};
    LogInfo("Response contains $rows_total rows of data.\n");

    my $ids = [ map { $_->{reqid} } @ch_data];
    my $log_date = [ map { $_->{log_date} } @ch_data];
    my $param = [ map { $_->{param} } @ch_data];

    open(my $file, '>', $filename)
        or die "Failed opening file $filename $!\n\n";
#   my $query_one_line = $query;
#   $query_one_line =~ s/[\r\n]+//r;
#   print $file encode_utf8($query_one_line);
    print $file "$rows_total";

    my $percent_done = 0;
    for (my $i = 0; $i < $rows_total; $i++) {
        if ($i % 100 == 0) {
            $percent_done = sprintf("%.2f",($i*100/$rows_total));
            LogInfo($percent_done."% processed...\n");
        }

        print $file encode_utf8("@{$ids}[$i]\t@{$log_date}[$i]\t@{$param}[$i]\t\n");
    }
    print $file "Successfully finished.\n";
    close $file;
    LogInfo("Result stored at\n\t$filename\n\n");

}

sub RunQueryForRangeOfDates {
    my $rq_query_template = $_[0];
    my @dates = @{$_[1]};

   foreach my $date_i (@dates) {
        my $filename_i = BuildFilename($rq_query_template, $date_i);
        my $query_i = BuildQuery($rq_query_template, $date_i);
        ExecuteQueryAndDumpToFile($query_i, $filename_i);
    }
}

my @JUNE = BuildDatesRange(6, 1, 7);
my @JULY = BuildDatesRange(7, 1, 7);
my @LAST = BuildDatesRange(7, 10, 16);

my %RANGES_ENUM;
push( @{ $RANGES_ENUM{ june } }, @JUNE);
push( @{ $RANGES_ENUM{ july } }, @JULY);
push( @{ $RANGES_ENUM{ last } }, @LAST);

my %QUERIES_ENUM = (
    "0", $CH_QUERY_TXT_CMP,
    "1", $CH_QUERY_OPT_NO,
    "2", $CH_QUERY_OPT_YES,
    "3", $CH_QUERY_SP_ON,
    "4", $CH_QUERY_BLK,
    "5", $CH_QUERY_BLK_OR_OP_Y,
    "6", $CH_QUERY_DEF,
);

LogInfo("Started.\nLogs written to $logfilename\n");

my $query_to_run = $QUERIES_ENUM{$query_num};
my @dates_to_run = @{ $RANGES_ENUM{$range_name} };

RunQueryForRangeOfDates($CH_QUERY_TXT_CMP, \@dates_to_run);

RunQueryForRangeOfDates($CH_QUERY_OPT_NO, \@dates_to_run);
RunQueryForRangeOfDates($CH_QUERY_OPT_YES, \@dates_to_run);
RunQueryForRangeOfDates($CH_QUERY_SP_ON, \@dates_to_run);
RunQueryForRangeOfDates($CH_QUERY_BLK, \@dates_to_run);
RunQueryForRangeOfDates($CH_QUERY_BLK_OR_OP_Y, \@dates_to_run);
RunQueryForRangeOfDates($CH_QUERY_DEF, \@dates_to_run);

LogInfo("Finished.\n");

