#!/usr/bin/perl

=head1 DESCRIPTION

Скрипт создаёт новые баннеры с креативами на основе родительских.
Анатог интапи-ручки BsFront:spawn_creatives

На вход ожидает tsv-файл формата
creative_group_id\told_creative_id\tnew_creative_id

=cut

use Direct::Modern;
use my_inc "../..";

use Settings;
use ScriptHelper;

use Path::Tiny;
use Yandex::ListUtils qw/chunks/;
use Yandex::Validate qw/is_valid_id/;
use Yandex::DBTools;
use Direct::Creatives;


my $CHUNK_SIZE = 10;

# https://bsint.yandex-team.ru/cgi-bin/global-host-options.cgi?name=export-dynamic-template-resource2-has-smart-tgo-orders-filter&switch=production
my @SKIP_ORDER_ID = (
    17595908, 17576933, 17597015, 17596603, 17857565, 17408222, 11662445, 11662306, 11662165, 11653220,
    11653040, 11652676, 11619631, 17912492, 17921755, 17871331, 8372784, 14152822, 14047754, 14231684,
    14274510, 18384516, 17691504, 12154217, 18081382, 18080282, 17557965, 17473052, 18189420, 17271975,
    9794212,14710134,11663396,9976307,9190283,14647888,14605134,14647850,17595115,17618522,17618555,
    17968528,17699946,16549483,12074222,12974147,14681312,12822584,16549483,12074222,12974147,14681312,
    12822584,13398407,14395782,15484029,15483989,14382453,15507194,14383747,15423102,15395845,8781202,
    15793065,10712438,15920852,15921506,16361935,16443875,16443914,16443919,16443933,16443963,15594444,
    15900090,15919991,15921651,10606893,12499952,17012292,15318497,12499970,7789094,9855539,9855538,
    9855536,9855535,9855550,9855551,9855548,9855549,9855558,9855559,9855560,9855561
);


extract_script_params(
    'i=s' => \my $input_file,
    'chunk-size=i' => \$CHUNK_SIZE,
);

die "No input file; stop"  if !$input_file;


$log->out('START');

$log->out("reading $input_file");

my @items;

my $tsv = path($input_file)->slurp_utf8;
for my $line (split /\n/ => $tsv) {
    next if !$line;

    my (undef, $old_creative_id, $new_creative_id) = split /\t/ => $line;
    next if $old_creative_id =~ /\D/ && $new_creative_id =~ /\D/;

    $log->die("ERROR: invalid data: $line")  if !is_valid_id($old_creative_id) || !is_valid_id($new_creative_id);

    push @items, [$new_creative_id, $old_creative_id];
}

$log->out(sprintf "%d pairs read" => scalar @items);
$log->die('ERROR: empty input; stop')  if !@items;

my $skip_cid = get_one_column_sql(PPC(shard => 'all'), [
        'SELECT cid FROM campaigns',
        WHERE => { OrderID => \@SKIP_ORDER_ID },
    ]);
$log->out(sprintf 'got %d campaigns to skip' => scalar @$skip_cid);

for my $items_chunk (chunks \@items, $CHUNK_SIZE) {
    my %child2parent = map {@$_} @$items_chunk;

    my $result = eval { Direct::Creatives::create_child_creatives(\%child2parent, skip_cid => $skip_cid) }
    or $log->die("ERROR: internal error $@");

    for my $item (@$items_chunk) {
        my ($new_creative_id, $old_creative_id) = @$item;
        my $message = "id=$new_creative_id: " . (
            $result->{created}->{$new_creative_id}
            ? "succeed" . ($result->{warnings}->{$new_creative_id} ? " ($result->{warnings}->{$new_creative_id})" : "")
            : "failed: $result->{errors}->{$new_creative_id}"
        );
        $log->out($message);
    }
}

$log->out('FINISH');


