#!/usr/bin/perl

=head1 DESCRIPTION

Скрипт для подсчета изменений урла за определенный период.
Подсчет ведется по бин-логам продакшена. Данные складывают в таблицу ppcdev.calc_href_change_tmp

Используется SettingsALL потому что бинлоги лежат в production, а временную таблицу имеет смысл создавать
только на тестовых БД

Параметры:

    --shard-id  шард (по умолчанию - 3)
    --date_from с какого момента считывать логи (по умолчанию 3 месяца до сегодняшнего дня)
    --date_to до какого момента считывать логи (по умолчанию сегодня)

Пример:

    ./DIRECT-73145_calc_change_href.pl --date_to 2017-09-15 --date_to 2017-12-15 --shard-id 3

=cut

use Direct::Modern;
use my_inc '../..';

use SettingsALL;

use Yandex::DBTools;
use Yandex::DateTime;
use Yandex::ListUtils;

use ScriptHelper;
use Tools;
use URI; 
my $TBL = "calc_href_change_tmp";
my $CHUNK_SIZE = 100000;

my $DATE_FROM;
my $DATE_TO;
my $SHARD=3;

extract_script_params(
    'date_from=s' => \$DATE_FROM,
    'date_to=s' => \$DATE_TO,
    'shard-id=i' => \$SHARD,
);

$DATE_FROM = (defined $DATE_FROM) ? Yandex::DateTime::date($DATE_FROM) : (now() - duration('3m'));
$DATE_TO   = (defined $DATE_TO) ? Yandex::DateTime::date($DATE_TO) : now();
my $curr_date = $DATE_FROM;


$log->out(sprintf("%s: START FROM %s TO %s", $SHARD, $DATE_FROM->ymd, $DATE_TO->ymd));
my $clh = Tools::get_clickhouse_handler('logs');

my $last_datetime = $DATE_FROM->ymd." ".$DATE_FROM->hms;
my $last_bid = 0;

my $sql_where = {table          => 'banners',
                 service        => 'direct.json-api',
                 method__in     => ['ads.update'],
                 'row.name__in' => ['href'],
                };

drop_tmp_table ();
create_tmp_table();

while (1) {
    my %changes;
    # используем два ключа, потому что за одну единицу datetime происходит очень много записей. Иногда даже случаются несколько пар datetime+primary_key
    # но таких очень мало, и этими повторениями пренебрегаем
    $sql_where->{datetime__ge} = $last_datetime;
    $sql_where->{primary_key__gt} = $last_bid;
    $sql_where->{date} = $curr_date->ymd() ;
    $log->out(sprintf("datetime: %s, primary_key: %s", $last_datetime, $last_bid));

    # Считываем в кликхаусе порцию логов на curr_date день
    my $sql = "SELECT primary_key, row.name, row.value, datetime from binlog_rows where ".
               sql_condition($sql_where).
               " ORDER BY datetime, primary_key LIMIT $CHUNK_SIZE FORMAT JSON";

    my $result = $clh->query($sql)->json->{data};

    my %bids;

    # Если нет записей, за curr_date, значит пора сменить дату и продолжать выборку
    if (!scalar(@$result) && $curr_date->ymd ne $DATE_TO->ymd) {
        $curr_date += duration('1d');
        $last_bid = 0;
        $last_datetime = $curr_date->ymd." 00:00:00";
        $log->out(sprintf("Change date: %s", $curr_date->ymd));
        next;
    }

    # Если дошли до нужного дня  - значит пора заканчивать выборку
    last if (!scalar(@$result) && $curr_date->ymd eq $DATE_TO->ymd);

    $last_datetime = @$result[-1]->{datetime};
    $last_bid = @$result[-1]->{primary_key};

    # Вычленяем href из row.name и row.value.
    for my $row ( @$result ) {

        my $href_index;
        for (my $i = 0; $i < scalar(@{$row->{'row.name'}}); $i++) {
            $href_index = $i if $row->{'row.name'}->[$i] eq 'href';
        }; 
        next unless defined $href_index;
        my $href = $row->{'row.value'}->[$href_index];
        push @{$bids{$row->{'primary_key'}}}, $href;

    }
    my @calc_fields = qw/ch_scheme ch_host ch_path ch_params add_params del_params cnt/;
    my @fields = ('bid', 'prev_href', @calc_fields);
    my $prev_hrefs = get_hashes_hash_sql(DEVTEST_PPC(shard=>$SHARD), ["SELECT * FROM $TBL", where => {bid => [keys(%bids)]}]);

    foreach my $bid (keys(%bids)) {
        # Если в базе не было записей для данного номера баннера, тогда предыдущим считаем первым из списка полученных
        my $prev_href_str = (defined $prev_hrefs->{$bid}) ? $prev_hrefs->{$bid}->{prev_href} : shift @{$bids{$bid}};
 
        my $prev_href = URI->new($prev_href_str);
        if (@{$bids{$bid}}) {
            foreach (@{$bids{$bid}}) {
            eval {
                $changes{$bid}->{prev_href} = $_;
                $changes{$bid}->{bid} = $bid;
                $changes{$bid}->{cnt} = 1;
                my $check_href = URI->new($changes{$bid}->{prev_href});
                foreach (@calc_fields) {
                    $changes{$bid}->{$_} = 0 if !defined $changes{$bid}->{$_};
                }

                # Сравниваем поля схемы, домена и пути в ссылке
                foreach my $f (qw/scheme host path/) {
                    if (! defined ($prev_href->$f) ||
                        ! defined $check_href->$f ||
                         $prev_href->$f ne $check_href->$f) {
                        $changes{$bid}->{"ch_$f"}++;
                    }
                }

                my %check_params = $check_href->query_form;
                my %prev_params = $prev_href->query_form;

                # появившиеся и исчезнувшие параметны в ссылке
                $changes{$bid}->{add_params} += scalar(@{xminus([keys(%check_params)], [keys(%prev_params)])});
                $changes{$bid}->{del_params} += scalar(@{xminus([keys(%prev_params)], [keys(%check_params)])});

                # Сравнимаем
                foreach (keys(%check_params)) {
                    if (defined $prev_params{$_} && $prev_params{$_} ne $check_params{$_}) {
                        $changes{$bid}->{ch_params}++;
                    }
                }
                $prev_href = $check_href;
            };
            if ($@) {
                $log->out(sprintf("ERROR: %s", $@));

            }
            }
        } else {
            $changes{$bid} = { bid => $bid, 
                               prev_href  => $prev_href_str,
                               map {$_ => 0} @calc_fields,
                             };
            $changes{$bid}->{cnt} = 1;
        }
    }

    do_mass_insert_sql(DEVTEST_PPC(shard=>$SHARD), "INSERT INTO $TBL (".
        join (", ", @fields). ") VALUES %s ON DUPLICATE KEY UPDATE prev_href=VALUES(prev_href), ".
        join (", ", map {"$_=$_+VALUES($_)"} @calc_fields),
        [ map {my $bid = $_; [map {$changes{$bid}->{$_}} @fields]} keys %changes ]);
}



sub create_tmp_table {
    do_sql(DEVTEST_PPC(shard=>$SHARD), "CREATE TABLE IF NOT EXISTS $TBL (
        bid BIGINT(20), 
        prev_href TEXT NOT NULL,
        ch_scheme INT, 
        ch_host INT,
        ch_path INT,
        ch_params INT,
        add_params INT,
        del_params INT,
        cnt INT,
        PRIMARY KEY (bid))");
}

sub drop_tmp_table {
    do_sql(DEVTEST_PPC(shard=>$SHARD), "DROP TABLE IF EXISTS $TBL");
}

$log->out('FINISH');

