#!/usr/bin/perl

use Direct::Modern;

use my_inc '../..';
use Settings;
use Yandex::DBTools;
use ScriptHelper;
use ShardingTools qw/ppc_shards/;

my $cid;
extract_script_params(
	'cid:i' => \$cid,
);

$log->out('START');

for my $shard (ppc_shards()) {
    $log->msg_prefix("shard:$shard");
    my $banner_ids = get_banner_ids($shard);
    next unless @$banner_ids;
    $log->out("Banner IDs to modify:", $banner_ids);
    set_status_moderate_ready($shard, $banner_ids);
}

$log->out('FINISH');

sub get_banner_ids {
    my $shard = shift;

    my $banner_ids = get_one_column_sql(PPC(shard => $shard), [qq/
		    SELECT b.bid 
    		    FROM banners_performance AS bp 
		    JOIN banners AS b ON bp.bid = b.bid/,
		    WHERE => {
		        'bp.statusModerate' => 'New',
			'b.statusModerate' => 'Yes',
			'b.LastChange__gt' => '2018-10-11 00:00:00',
			'b.banner_type' => [qw/image_ad cpc_video/],
			( defined $cid ? ('b.cid' => $cid) : ())}
		
	]);
    return $banner_ids;
}


sub set_status_moderate_ready {
    my ($shard, $banner_ids) = @_;

    my $rows_updated = do_update_table(PPC(shard => $shard),
	    'banners_performance bp join banners b using (bid)',
	    {
		    'bp.statusModerate' => 'Ready',
		    'b.statusModerate' => 'Ready'
	    },
	    where => {
		    'bp.bid' => $banner_ids, 
		    'bp.statusModerate' => 'New',
		    'b.statusModerate' => 'Yes',
	    });
    $log->out("Updated $rows_updated rows");
}
