#!/usr/bin/perl

=head1 NAME


=head1 DESCRIPTION

Для ТС до переналивки базы Биллинга:
./protected/one-shot/add_products_for_cpm_audio.pl --test

Для продакшена и для тестовых сред после переналивки базы Биллинга:
./protected/one-shot/add_products_for_cpm_audio.pl --prod

=cut

use Direct::Modern;

use Yandex::DBTools;

use my_inc "../..";

use ScriptHelper;
use Settings;
use EnvTools;

$log->out('START');

my $PROD_DATA = [
    [509895, "Директ, аудиореклама, RUB", 0, "cpm_audio",1.000000,"RUB", 0,"Bucks",7,1,undef,undef,undef,undef, 'shows', 1, 'cpm'],
    [509897, "Директ, аудиореклама, USD", 0, "cpm_audio",1.000000,"USD", 0,"Bucks",7,1,undef,undef,undef,undef, 'shows', 1, 'cpm'],
    [509898, "Директ, аудиореклама, EUR", 0, "cpm_audio",1.000000,"EUR", 0,"Bucks",7,1,undef,undef,undef,undef, 'shows', 1, 'cpm'],
    [509899, "Директ, аудиореклама, UAH", 0, "cpm_audio",1.000000,"UAH", 0,"Bucks",7,1,undef,undef,undef,undef, 'shows', 1, 'cpm'],
    [509900, "Директ, аудиореклама, CHF", 0, "cpm_audio",1.000000,"CHF", 0,"Bucks",7,1,undef,undef,undef,undef, 'shows', 1, 'cpm'],
    [509901, "Директ, аудиореклама, TRY", 0, "cpm_audio",1.000000,"TRY", 0,"Bucks",7,1,undef,undef,undef,undef, 'shows', 1, 'cpm'],
    [509902, "Директ, аудиореклама, BYN", 0, "cpm_audio",1.000000,"BYN", 0,"Bucks",7,1,undef,undef,undef,undef, 'shows', 1, 'cpm'],
    [509903, "Директ, аудиореклама, KZT (фишки)", 0, "cpm_audio",1.000000,"KZT", 0,"QuasiCurrency",7,1,undef,undef,undef,undef, 'shows', 1, 'cpm'],
    [509904, "Директ, аудиореклама, KZT", 0, "cpm_audio",1.000000,"KZT",0,"Bucks",7,1,undef,undef,undef,undef, 'shows', 1, 'cpm'],
];

my $TEST_DATA = [
    [509895, "Директ, аудиореклама, RUB", 0, "cpm_audio",1.000000,"RUB", 0,"Bucks",7,1,undef,undef,undef,undef, 'shows', 1, 'cpm'],
    [509897, "Директ, аудиореклама, USD", 0, "cpm_audio",1.000000,"USD", 0,"Bucks",7,1,undef,undef,undef,undef, 'shows', 1, 'cpm'],
    [509898, "Директ, аудиореклама, EUR", 0, "cpm_audio",1.000000,"EUR", 0,"Bucks",7,1,undef,undef,undef,undef, 'shows', 1, 'cpm'],
    [509899, "Директ, аудиореклама, UAH", 0, "cpm_audio",1.000000,"UAH", 0,"Bucks",7,1,undef,undef,undef,undef, 'shows', 1, 'cpm'],
    [509900, "Директ, аудиореклама, CHF", 0, "cpm_audio",1.000000,"CHF", 0,"Bucks",7,1,undef,undef,undef,undef, 'shows', 1, 'cpm'],
    [509901, "Директ, аудиореклама, TRY", 0, "cpm_audio",1.000000,"TRY", 0,"Bucks",7,1,undef,undef,undef,undef, 'shows', 1, 'cpm'],
    [509902, "Директ, аудиореклама, BYN", 0, "cpm_audio",1.000000,"BYN", 0,"Bucks",7,1,undef,undef,undef,undef, 'shows', 1, 'cpm'],
    [509903, "Директ, аудиореклама, KZT (фишки)", 0, "cpm_audio",1.000000,"KZT", 0,"QuasiCurrency",7,1,undef,undef,undef,undef, 'shows', 1, 'cpm'],
    [509904, "Директ, аудиореклама, KZT", 0, "cpm_audio",1.000000,"KZT",0,"Bucks",7,1,undef,undef,undef,undef, 'shows', 1, 'cpm'],
];

my ($PROD, $TEST);
extract_script_params(
    'prod' => \$PROD,
    'test' => \$TEST,
);

die "--prod or --test missing, stop\n" unless $PROD || $TEST;

my $DATA;
my $is_prod = is_production();

if ( $is_prod && $PROD ){
    $DATA = $PROD_DATA;
} elsif (   $is_prod && $TEST ) {
    die "won't run with --test in production, stop\n";
} elsif ( ! $is_prod && $PROD ) {
    $DATA = $PROD_DATA;
} elsif ( ! $is_prod && $TEST ) {
    $DATA = $TEST_DATA;
} else {
    die "don't know what to do, stop\n";
}

$log->out("going to insert:", $DATA);

do_mass_insert_sql(PPCDICT, 'insert into products ( ProductID, product_name, theme_id, type, Price, currency, NDS, UnitName, EngineID, Rate, daily_shows, packet_size, public_name_key, public_description_key, unit, unit_scale, calc_type ) values %s', $DATA);

$log->out("FINISH");
