#!/usr/bin/perl

=head1 NAME


=head1 DESCRIPTION

Для ТС:
./protected/one-shot/add_products_for_cpm_banner.pl --test

Для продакшена (на ТС тоже можно)
./protected/one-shot/add_products_for_cpm_banner.pl --prod

=cut

use Direct::Modern;

use List::MoreUtils 'zip';

use Yandex::DBTools;

use my_inc "../..";

use ScriptHelper;
use Settings;

$log->out('START');

my $DATA = [
[508597, "Тест. Директ CPM, фишки", 0, "cpm_banner",1.000000,"YND_FIXED",1,"Bucks",7,1,undef,undef],
[508587, "Тест. Директ CPM, RUB",   0, "cpm_banner",1.000000,"RUB",      0,"Bucks",7,1,undef,undef],
[508588, "Тест. Директ CPM, USD",   0, "cpm_banner",1.000000,"USD",      0,"Bucks",7,1,undef,undef],
[508589, "Тест. Директ CPM, EUR",   0, "cpm_banner",1.000000,"EUR",      0,"Bucks",7,1,undef,undef],
[508590, "Тест. Директ CPM, UAH",   0, "cpm_banner",1.000000,"UAH",      0,"Bucks",7,1,undef,undef],
[508596, "Тест. Директ CPM, квази KZT", 0, "cpm_banner",1.000000,"KZT",  0,"QuasiCurrency",7,1,undef,undef],
[508591, "Тест. Директ CPM, CHF",   0, "cpm_banner",1.000000,"CHF",      0,"Bucks",7,1,undef,undef],
[508592, "Тест. Директ CPM, TRY",   0, "cpm_banner",1.000000,"TRY",      0,"Bucks",7,1,undef,undef],
[508594, "Тест. Директ CPM, BYN",   0, "cpm_banner",1.000000,"BYN",      0,"Bucks",7,1,undef,undef],
[508892, "Тест. Директ CPM, KZT",   0, "cpm_banner",1.000000,"KZT",      0,"Bucks",7,1,undef,undef],
];

my @fields = qw( ProductID product_name theme_id type Price currency NDS UnitName EngineID Rate daily_shows packet_size );
for my $values (@$DATA) {
    my %record = zip @fields, @$values;
    $log->out("going to insert:", \%record);
    do_insert_into_table(PPCDICT, 'products', \%record, on_duplicate_key_update => 1);
}

$log->out("FINISH");

