#!/usr/bin/perl

=head1 NAME


=head1 DESCRIPTION

Для ТС:
./protected/one-shot/add_products_for_cpm_deals.pl --test

Для продакшена (на ТС тоже можно)
./protected/one-shot/add_products_for_cpm_deals.pl --prod

=cut

use Direct::Modern;

use Yandex::DBTools;

use my_inc "../..";

use ScriptHelper;
use Settings;
use EnvTools;

$log->out('START');

my $PROD_DATA = [
    [508918, "Private marketplace, RUB",         0, "cpm_deals",1.000000,"RUB",      0,"Bucks",7,1,undef,undef],
    [508919, "Private marketplace, USD",         0, "cpm_deals",1.000000,"USD",      0,"Bucks",7,1,undef,undef],
    [508920, "Private marketplace, EUR",         0, "cpm_deals",1.000000,"EUR",      0,"Bucks",7,1,undef,undef],
    [508922, "Private marketplace, UAH",         0, "cpm_deals",1.000000,"UAH",      0,"Bucks",7,1,undef,undef],
    [508928, "Private marketplace, KZT",         0, "cpm_deals",1.000000,"KZT",      0,"Bucks",7,1,undef,undef],
    [508927, "Private marketplace, KZT (фишки)", 0, "cpm_deals",1.000000,"KZT",      0,"QuasiCurrency",7,1,undef,undef],
    [508923, "Private marketplace, CHF",         0, "cpm_deals",1.000000,"CHF",      0,"Bucks",7,1,undef,undef],
    [508924, "Private marketplace, TRY",         0, "cpm_deals",1.000000,"TRY",      0,"Bucks",7,1,undef,undef],
    [508925, "Private marketplace, BYN",         0, "cpm_deals",1.000000,"BYN",      0,"Bucks",7,1,undef,undef],
];

my $TEST_DATA = [
    [10000035, "Медийная рекламная кампания РРС (рубли)",       0, "cpm_deals",1.000000,"RUB",      0,"Bucks",7,1,undef,undef],
    [10000034, "Медийная рекламная кампания РРС (USD)",         0, "cpm_deals",1.000000,"USD",      0,"Bucks",7,1,undef,undef],
    [10000030, "Медийная рекламная кампания РРС (EUR)",         0, "cpm_deals",1.000000,"EUR",      0,"Bucks",7,1,undef,undef],
    [10000031, "Медийная рекламная кампания РРС (UAH)",         0, "cpm_deals",1.000000,"UAH",      0,"Bucks",7,1,undef,undef],
    [10000038, "Медийная рекламная кампания РРС (KZT, валюта)", 0, "cpm_deals",1.000000,"KZT",      0,"Bucks",7,1,undef,undef],
    [10000037, "Медийная рекламная кампания РРС (KZT)",         0, "cpm_deals",1.000000,"KZT",      0,"QuasiCurrency",7,1,undef,undef],
    [10000032, "Медийная рекламная кампания РРС (CHF)",         0, "cpm_deals",1.000000,"CHF",      0,"Bucks",7,1,undef,undef],
    [10000033, "Медийная рекламная кампания РРС (TRY)",         0, "cpm_deals",1.000000,"TRY",      0,"Bucks",7,1,undef,undef],
    [10000036, "Медийная рекламная кампания РРС (BYN)",         0, "cpm_deals",1.000000,"BYN",      0,"Bucks",7,1,undef,undef],
];


my ($PROD, $TEST);
extract_script_params(
    'prod' => \$PROD,
    'test' => \$TEST,
);

die "--prod or --test missing, stop\n" unless $PROD || $TEST;

my $DATA;

if (        is_production() && $PROD ){
    $DATA = $PROD_DATA;
} elsif (   is_production() && $TEST ) {
    die "won't run with --test in production, stop\n";
} elsif ( ! is_production() && $PROD ) {
    $DATA = $PROD_DATA;
} elsif ( ! is_production() && $TEST ) {
    $DATA = $TEST_DATA;
} else {
    die "don't know what to do, stop\n";
}

$log->out("going to insert:", $DATA);

do_mass_insert_sql(PPCDICT, 'insert into products ( ProductID, product_name, theme_id, type, Price, currency, NDS, UnitName, EngineID, Rate, daily_shows, packet_size ) values %s', $DATA);

$log->out("FINISH");

