#!/usr/bin/perl

=head1 NAME


=head1 DESCRIPTION

Для ТС до переналивки базы Биллинга:
./protected/one-shot/add_products_for_cpm_indoor.pl --test

Для продакшена и для тестовых сред после переналивки базы Биллинга:
./protected/one-shot/add_products_for_cpm_indoor.pl --prod

=cut

use Direct::Modern;

use Yandex::DBTools;

use my_inc "../..";

use ScriptHelper;
use Settings;
use EnvTools;

$log->out('START');


my $PROD_DATA = [
    [509852, "Indoor видео объявления CPM, RUB",       0, "cpm_indoor",1.000000,"RUB",      0,"Bucks",7,1,undef,undef],
    [509853, "Indoor видео объявления CPM, USD",       0, "cpm_indoor",1.000000,"USD",      0,"Bucks",7,1,undef,undef],
    [509854, "Indoor видео объявления CPM, EUR",       0, "cpm_indoor",1.000000,"EUR",      0,"Bucks",7,1,undef,undef],
    [509855, "Indoor видео объявления CPM, UAH",       0, "cpm_indoor",1.000000,"UAH",      0,"Bucks",7,1,undef,undef],
    [509856, "Indoor видео объявления CPM, CHF",       0, "cpm_indoor",1.000000,"CHF",      0,"Bucks",7,1,undef,undef],
    [509857, "Indoor видео объявления CPM, TRY",       0, "cpm_indoor",1.000000,"TRY",      0,"Bucks",7,1,undef,undef],
    [509858, "Indoor видео объявления CPM, BYN",       0, "cpm_indoor",1.000000,"BYN",      0,"Bucks",7,1,undef,undef],
    [509859, "Indoor видео объявления CPM, квази KZT", 0, "cpm_indoor",1.000000,"KZT",      0,"QuasiCurrency",7,1,undef,undef],
    [509860, "Indoor видео объявления CPM, KZT",       0, "cpm_indoor",1.000000,"KZT",      0,"Bucks",7,1,undef,undef],
];

my $TEST_DATA = [
    [509449, "Indoor видео объявления CPM, RUB",       0, "cpm_indoor",1.000000,"RUB",      0,"Bucks",7,1,undef,undef],
    [509450, "Indoor видео объявления CPM, USD",       0, "cpm_indoor",1.000000,"USD",      0,"Bucks",7,1,undef,undef],
    [509451, "Indoor видео объявления CPM, EUR",       0, "cpm_indoor",1.000000,"EUR",      0,"Bucks",7,1,undef,undef],
    [509452, "Indoor видео объявления CPM, UAH",       0, "cpm_indoor",1.000000,"UAH",      0,"Bucks",7,1,undef,undef],
    [509453, "Indoor видео объявления CPM, CHF",       0, "cpm_indoor",1.000000,"CHF",      0,"Bucks",7,1,undef,undef],
    [509454, "Indoor видео объявления CPM, TRY",       0, "cpm_indoor",1.000000,"TRY",      0,"Bucks",7,1,undef,undef],
    [509455, "Indoor видео объявления CPM, BYN",       0, "cpm_indoor",1.000000,"BYN",      0,"Bucks",7,1,undef,undef],
    [509456, "Indoor видео объявления CPM, квази KZT", 0, "cpm_indoor",1.000000,"KZT",      0,"QuasiCurrency",7,1,undef,undef],
    [509457, "Indoor видео объявления CPM, KZT",       0, "cpm_indoor",1.000000,"KZT",      0,"Bucks",7,1,undef,undef],
];

my ($PROD, $TEST);
extract_script_params(
    'prod' => \$PROD,
    'test' => \$TEST,
);

die "--prod or --test missing, stop\n" unless $PROD || $TEST;

my $DATA;
my $is_prod = is_production();

if (        $is_prod && $PROD ){
    $DATA = $PROD_DATA;
} elsif (   $is_prod && $TEST ) {
    die "won't run with --test in production, stop\n";
} elsif ( ! $is_prod && $PROD ) {
    $DATA = $PROD_DATA;
} elsif ( ! $is_prod && $TEST ) {
    $DATA = $TEST_DATA;
} else {
    die "don't know what to do, stop\n";
}

$log->out("going to insert:", $DATA);

do_mass_insert_sql(PPCDICT, 'insert into products ( ProductID, product_name, theme_id, type, Price, currency, NDS, UnitName, EngineID, Rate, daily_shows, packet_size ) values %s', $DATA);

$log->out("FINISH");

