#!/usr/bin/perl

=head1 NAME


=head1 DESCRIPTION

Для ТС до переналивки базы Биллинга:
./protected/one-shot/add_products_for_cpm_outdoor.pl --test

Для продакшена и для тестовых сред после переналивки базы Биллинга:
./protected/one-shot/add_products_for_cpm_outdoor.pl --prod

=cut

use Direct::Modern;

use Yandex::DBTools;

use my_inc "../..";

use ScriptHelper;
use Settings;
use EnvTools;

$log->out('START');


my $PROD_DATA = [
    [509675, "Outdoor видео объявления CPM, RUB",       0, "cpm_outdoor",1.000000,"RUB",      0,"Bucks",7,1,undef,undef],
    [509676, "Outdoor видео объявления CPM, USD",       0, "cpm_outdoor",1.000000,"USD",      0,"Bucks",7,1,undef,undef],
    [509677, "Outdoor видео объявления CPM, EUR",       0, "cpm_outdoor",1.000000,"EUR",      0,"Bucks",7,1,undef,undef],
    [509678, "Outdoor видео объявления CPM, UAH",       0, "cpm_outdoor",1.000000,"UAH",      0,"Bucks",7,1,undef,undef],
    [509679, "Outdoor видео объявления CPM, CHF",       0, "cpm_outdoor",1.000000,"CHF",      0,"Bucks",7,1,undef,undef],
    [509680, "Outdoor видео объявления CPM, TRY",       0, "cpm_outdoor",1.000000,"TRY",      0,"Bucks",7,1,undef,undef],
    [509681, "Outdoor видео объявления CPM, BYN",       0, "cpm_outdoor",1.000000,"BYN",      0,"Bucks",7,1,undef,undef],
    [509682, "Outdoor видео объявления CPM, квази KZT", 0, "cpm_outdoor",1.000000,"KZT",      0,"QuasiCurrency",7,1,undef,undef],
    [509683, "Outdoor видео объявления CPM, KZT",       0, "cpm_outdoor",1.000000,"KZT",      0,"Bucks",7,1,undef,undef],
];

my $TEST_DATA = [
    [509440, "Outdoor видео объявления CPM, RUB",       0, "cpm_outdoor",1.000000,"RUB",      0,"Bucks",7,1,undef,undef],
    [509441, "Outdoor видео объявления CPM, USD",       0, "cpm_outdoor",1.000000,"USD",      0,"Bucks",7,1,undef,undef],
    [509442, "Outdoor видео объявления CPM, EUR",       0, "cpm_outdoor",1.000000,"EUR",      0,"Bucks",7,1,undef,undef],
    [509443, "Outdoor видео объявления CPM, UAH",       0, "cpm_outdoor",1.000000,"UAH",      0,"Bucks",7,1,undef,undef],
    [509444, "Outdoor видео объявления CPM, CHF",       0, "cpm_outdoor",1.000000,"CHF",      0,"Bucks",7,1,undef,undef],
    [509445, "Outdoor видео объявления CPM, TRY",       0, "cpm_outdoor",1.000000,"TRY",      0,"Bucks",7,1,undef,undef],
    [509446, "Outdoor видео объявления CPM, BYN",       0, "cpm_outdoor",1.000000,"BYN",      0,"Bucks",7,1,undef,undef],
    [509447, "Outdoor видео объявления CPM, квази KZT", 0, "cpm_outdoor",1.000000,"KZT",      0,"QuasiCurrency",7,1,undef,undef],
    [509448, "Outdoor видео объявления CPM, KZT",       0, "cpm_outdoor",1.000000,"KZT",      0,"Bucks",7,1,undef,undef],
];


my ($PROD, $TEST);
extract_script_params(
    'prod' => \$PROD,
    'test' => \$TEST,
);

die "--prod or --test missing, stop\n" unless $PROD || $TEST;

my $DATA;
my $is_prod = is_production();

if (        $is_prod && $PROD ){
    $DATA = $PROD_DATA;
} elsif (   $is_prod && $TEST ) {
    die "won't run with --test in production, stop\n";
} elsif ( ! $is_prod && $PROD ) {
    $DATA = $PROD_DATA;
} elsif ( ! $is_prod && $TEST ) {
    $DATA = $TEST_DATA;
} else {
    die "don't know what to do, stop\n";
}

$log->out("going to insert:", $DATA);

do_mass_insert_sql(PPCDICT, 'insert into products ( ProductID, product_name, theme_id, type, Price, currency, NDS, UnitName, EngineID, Rate, daily_shows, packet_size ) values %s', $DATA);

$log->out("FINISH");

