#!/usr/bin/perl

=head1 NAME


=head1 DESCRIPTION

Для ТС до переналивки базы Биллинга:
./protected/one-shot/add_products_for_cpm_video.pl --test

Для продакшена и для тестовых сред после переналивки базы Биллинга:
./protected/one-shot/add_products_for_cpm_video.pl --prod

=cut

use Direct::Modern;

use Yandex::DBTools;

use my_inc "../..";

use ScriptHelper;
use Settings;
use EnvTools;

$log->out('START');


my $PROD_DATA = [
[509619, "Видео объявления CPM, RUB",       0, "cpm_video",1.000000,"RUB",      0,"Bucks",7,1,undef,undef],
[509620, "Видео объявления CPM, USD",       0, "cpm_video",1.000000,"USD",      0,"Bucks",7,1,undef,undef],
[509621, "Видео объявления CPM, EUR",       0, "cpm_video",1.000000,"EUR",      0,"Bucks",7,1,undef,undef],
[509622, "Видео объявления CPM, UAH",       0, "cpm_video",1.000000,"UAH",      0,"Bucks",7,1,undef,undef],
[509623, "Видео объявления CPM, CHF",       0, "cpm_video",1.000000,"CHF",      0,"Bucks",7,1,undef,undef],
[509624, "Видео объявления CPM, TRY",       0, "cpm_video",1.000000,"TRY",      0,"Bucks",7,1,undef,undef],
[509625, "Видео объявления CPM, BYN",       0, "cpm_video",1.000000,"BYN",      0,"Bucks",7,1,undef,undef],
[509626, "Видео объявления CPM, квази KZT", 0, "cpm_video",1.000000,"KZT",      0,"QuasiCurrency",7,1,undef,undef],
[509627, "Видео объявления CPM, KZT",       0, "cpm_video",1.000000,"KZT",      0,"Bucks",7,1,undef,undef],
];

my $TEST_DATA = [
[509420, "Видео объявления CPM, RUB",       0, "cpm_video",1.000000,"RUB",      0,"Bucks",7,1,undef,undef],
[509421, "Видео объявления CPM, USD",       0, "cpm_video",1.000000,"USD",      0,"Bucks",7,1,undef,undef],
[509422, "Видео объявления CPM, EUR",       0, "cpm_video",1.000000,"EUR",      0,"Bucks",7,1,undef,undef],
[509423, "Видео объявления CPM, UAH",       0, "cpm_video",1.000000,"UAH",      0,"Bucks",7,1,undef,undef],
[509424, "Видео объявления CPM, CHF",       0, "cpm_video",1.000000,"CHF",      0,"Bucks",7,1,undef,undef],
[509425, "Видео объявления CPM, TRY",       0, "cpm_video",1.000000,"TRY",      0,"Bucks",7,1,undef,undef],
[509426, "Видео объявления CPM, BYN",       0, "cpm_video",1.000000,"BYN",      0,"Bucks",7,1,undef,undef],
[509427, "Видео объявления CPM, квази KZT", 0, "cpm_video",1.000000,"KZT",      0,"QuasiCurrency",7,1,undef,undef],
[509428, "Видео объявления CPM, KZT",       0, "cpm_video",1.000000,"KZT",      0,"Bucks",7,1,undef,undef],
];


my ($PROD, $TEST);
extract_script_params(
    'prod' => \$PROD,
    'test' => \$TEST,
);

die "--prod or --test missing, stop\n" unless $PROD || $TEST;

my $DATA;
my $is_prod = is_production();

if (        $is_prod && $PROD ){
    $DATA = $PROD_DATA;
} elsif (   $is_prod && $TEST ) {
    die "won't run with --test in production, stop\n";
} elsif ( ! $is_prod && $PROD ) {
    $DATA = $PROD_DATA;
} elsif ( ! $is_prod && $TEST ) {
    $DATA = $TEST_DATA;
} else {
    die "don't know what to do, stop\n";
}

$log->out("going to insert:", $DATA);

do_mass_insert_sql(PPCDICT, 'insert into products ( ProductID, product_name, theme_id, type, Price, currency, NDS, UnitName, EngineID, Rate, daily_shows, packet_size ) values %s', $DATA);

$log->out("FINISH");

