#!/usr/bin/perl

=head1 NAME

add_products_for_internal_autobudget.pl

=head1 DESCRIPTION

Для ТС до переналивки базы Биллинга:
./protected/one-shot/add_products_for_internal_autobudget.pl --test

Для продакшена и для тестовых сред после переналивки базы Биллинга:
./protected/one-shot/add_products_for_internal_autobudget.pl --prod

=cut

use Direct::Modern;

use Yandex::DBTools;

use my_inc "../..";

use ScriptHelper;
use Settings;
use EnvTools;

$log->out('START');

my $PROD_DATA = [
[511422, "Внутренняя реклама. Автобюджетные заказы", 0, 'internal_autobudget', 1.000000, 'RUB', 0, 'Bucks', 67, 1, undef, undef, 'clicks', 1, 'cpc'],
];

my $TEST_DATA = [
[511422, "Внутренняя реклама. Автобюджетные заказы", 0, 'internal_autobudget', 1.000000, 'RUB', 0, 'Bucks', 67, 1, undef, undef, 'clicks', 1, 'cpc'],
];


my ($PROD, $TEST);
extract_script_params(
    'prod' => \$PROD,
    'test' => \$TEST,
);

die "--prod or --test missing, stop\n" unless $PROD || $TEST;

my $DATA;
my $is_prod = is_production();

if (        $is_prod && $PROD ){
    $DATA = $PROD_DATA;
} elsif (   $is_prod && $TEST ) {
    die "won't run with --test in production, stop\n";
} elsif ( ! $is_prod && $PROD ) {
    $DATA = $PROD_DATA;
} elsif ( ! $is_prod && $TEST ) {
    $DATA = $TEST_DATA;
} else {
    die "don't know what to do, stop\n";
}

$log->out("going to insert:", $DATA);

do_mass_insert_sql(PPCDICT, 'insert into products ( ProductID, product_name, theme_id, type, Price, currency, NDS, UnitName, EngineID, Rate, daily_shows, packet_size, unit, unit_scale, calc_type ) values %s', $DATA);

$log->out("FINISH");

