#!/usr/bin/perl

=head1 NAME

$Id: $

=head1 DESCRIPTION

    Конвертация настроек АДФ/ДРФ в настройки объединенного авторасширения фраз
    Выставляется ограничение на расход бюджета (broad_match_limit) на основании статистики по расходу, посчитанной convert_adf_drf.pl
    Данные берутся из заранее подготовленных файлов filename_SHARD.
  .

=head1 RUNNING

    ./protected/one-shot/adf_drf_from_file.pl --filename

=cut


use Direct::Modern;
use my_inc "../..";

use Settings;
use ShardingTools qw/foreach_shard_parallel_verbose/;
use Yandex::DBTools;

use ScriptHelper 
    'Yandex::Log' => 'messages';

# Количество кампаний, обновляемых за одну итерацию
my $MAX_CAMPAIGNS = 1000;


my ($dry_run, $filename);
extract_script_params(
    'dry-run' => \$dry_run,
    'filename=s' => \$filename,
);

die '--filename required' unless $filename;

foreach_shard_parallel_verbose( $log, sub {
        my $shard = shift;
        $log->out("Starting - shard: $shard");
        my $fname = "${filename}_$shard";
        open(my $fh, '<', $fname) or die "Can't open file $fname";
        my $data;
        while (!eof($fh) && ($data = read_data($fh, $MAX_CAMPAIGNS))) {
            update_campaigns($shard => $data);
        }
        $log->out("Completed - shard: $shard");
    }
);

sub read_data {
    my ($fh, $limit) = @_;
    my ($row, $data);
    while (!eof($fh) && $limit-- > 0) {
        $row = <$fh> || close($fh);
        if (defined $row && $row =~/(\d+)\s+(\d+)/) {
            $data->{$1}->{'co.broad_match_limit'} = $2;
        }
    }
    return $data;    
}

sub update_campaigns {
    my ($shard, $update_data) = @_;
    unless ($dry_run) {
        do_mass_update_sql(PPC(shard => $shard), 'camp_options co JOIN campaigns c ON (c.cid = co.cid)',
            'co.cid' => $update_data,
            byfield_options => {
                'c.LastChange' => {default__dont_quote => 'Now()'},
                'co.broad_match_rate' => {default => 'unused'},
                'co.broad_match_flag' => {default => 'Yes'},
            }
        );
    }
}


