#!/usr/bin/perl

=head1 DESCRIPTION

    --file=agency_clientids.txt - файл с ClientID агентств, которым нужно разрешить создавать клиентов без ОС
    --client-id=23131 - ClientID агентства

=cut

use Direct::Modern;

use JSON;

use Yandex::DBTools;
use Yandex::DBShards;

use my_inc '../..';

use ScriptHelper;
use Settings;

extract_script_params(
    'file=s' => \my $filename,
    'client-id=i' => \my $client_id,
);
unless (defined $filename || defined $client_id) {
    die "please specify --client-id, or a file with agency ClientIDs via --file\n";
}

my @client_ids;
if ($filename) {
    unless (-f $filename) {
        $log->die("can't open $filename");
    }

    open my $fh, "<", $filename;
    while (<$fh>) {
        chomp;
        next unless $_;
        push @client_ids, $_;
    }
    close $fh;
} else {
    push @client_ids, $client_id;
}

$log->out('START');

foreach_shard ClientID => \@client_ids, chunk_size => 1_000, with_undef_shard => 1, sub {
    my ($shard, $client_ids_chunk) = @_;

    unless ($shard) {
        $log->out("couldn't find shard for these ClientIDs", $client_ids_chunk);
        return;
    }

    $client_ids_chunk = get_one_column_sql(PPC(shard => $shard), ["
        SELECT ClientID
        FROM agency_options",
        WHERE => {
            ClientID => $client_ids_chunk,
            allow_clients_without_wallet__ne => 1,
        }
    ]);

    my $updated = 0 + do_sql(PPC(shard => $shard), ["
        UPDATE agency_options ao
            JOIN clients cl ON ao.ClientID = cl.ClientID
        SET
            ao.allow_clients_without_wallet = 1,
            ao.default_clients_with_wallet = cl.agency_allow_wallet",
        WHERE => {
            'ao.ClientID' => $client_ids_chunk,
        }
    ]);

    $log->out("[shard $shard] allowed clients without wallets for $updated AgencyIDs: ".to_json($client_ids_chunk));
};

$log->out('FINISH');
