#!/usr/bin/perl
use my_inc "../..";

=head2 NAME 
    
    DIRECT-41501-strict-mode.pl
    DIRECT-41501 - Включить strict режим для ppcfiles

=head2 DESCRIPTION

    После перехода БД ppcfiles на strict режим переобходит все неправильные поля и обновляет.
    Раньше было допустимо иметь дату 0000-00-00 00:00:00. Теперь нельзя. Заменяет на NULL.

    скрипт можно запускать повторно и останавливать в процессе выполнения
    если будут сильно отставать реплики, то увеличить --sleep-coef

    как проверить успешность выполнения скрипта:
    0 == SELECT COUNT(*) FROM xls_reports WHERE processing_time = '0000-00-00 00:00:00' OR ready_time = '0000-00-00 00:00:00'

=cut

use Direct::Modern;
use Yandex::DBTools;
use Settings;
use Yandex::Retry;
use ScriptHelper;

use constant CHUNK_SIZE => 200;

my $SLEEP_COEF = 0.1;
extract_script_params(
    'sleep-coef' => \$SLEEP_COEF,
);

$log->out("start");

my ($min_id, $max_id) = get_one_line_array_sql(PPCFILES, "SELECT MIN(id), MAX(id) FROM xls_reports");

$log->out("found ~ " . ($max_id - $min_id) . " rows");

while ($min_id <= $max_id) {
    relaxed times => $SLEEP_COEF, sub {
        my $affected = do_sql(PPCFILES,
          "UPDATE xls_reports
              SET processing_time = IF(processing_time = '0000-00-00 00:00:00', NULL, processing_time),
              ready_time = IF(ready_time = '0000-00-00 00:00:00', NULL, ready_time)
          WHERE id BETWEEN ? AND ? AND (processing_time = '0000-00-00 00:00:00' OR ready_time = '0000-00-00 00:00:00')",
          $min_id, $min_id + CHUNK_SIZE - 1
        );
        $log->out("processed " . ($affected + 0) . " rows");
    };
    $min_id += CHUNK_SIZE;
}

$log->out("finish");
