#!/usr/bin/perl

use my_inc '../..';

use Direct::Modern;

use Yandex::DateTime qw(date);
use Yandex::DBShards;
use Yandex::DBTools;
use Yandex::Retry;
use Yandex::TimeCommon qw(yesterday);

use DBStat ();
use ScriptHelper;
use Settings;
use ShardingTools;
use Stat::Const qw/$BEGIN_OF_TIME_FOR_STAT/;

$log->out('START');

foreach_shard shard => [ppc_shards()], sub {
    my ($shard) = @_;

    $log->msg_prefix("[shard_$shard]");
    $log->out('Fetching orders to fix');
    my $orders_data = get_all_sql(PPC(shard => $shard), ['
        SELECT
            c.OrderID,
            DATE_FORMAT(ccc.date, "%Y%m%d") AS first_date_in_real_currency,
            DATE_FORMAT(co.create_time, "%Y%m%d") AS create_time
        FROM currency_convert_queue q
        INNER JOIN users u ON q.ClientID = u.ClientID
        INNER JOIN campaigns c ON c.uid = u.uid
        LEFT JOIN camp_options co ON c.cid = co.cid
        INNER JOIN client_currency_changes ccc ON ccc.ClientID = u.ClientID AND ccc.currency_from = "YND_FIXED"
        WHERE
                q.state = "DONE"
            AND q.convert_type = "MODIFY"
            AND c.currencyConverted = "Yes"
            AND c.OrderID > 0
            AND c.shows > 0
    ']);
    $log->out('Got ' . scalar(@$orders_data) . ' orders to fix');

    for my $order (@$orders_data) {
        my $order_id = $order->{OrderID};
        my $create_time = $order->{create_time} && $order->{create_time} ne '00000000' ? $order->{create_time} : $BEGIN_OF_TIME_FOR_STAT;
        my $last_day_in_ynd_fixed = yesterday($order->{first_date_in_real_currency});
        $log->out("Fixing statistics for order $order_id from $create_time till $last_day_in_ynd_fixed");
        eval { retry tries => 5, sub {
            my $is_error = DBStat::refresh_quick_order_stat(OrderID => $order_id, from_date => $create_time, to_date => date($last_day_in_ynd_fixed));
            if ($is_error) {
                die "ERROR refreshing OrderID $order_id from $create_time till $last_day_in_ynd_fixed: status = $is_error";
            };
        } };
        if ($@) {
            $log->out($@);
        }
    }
};

$log->out('FINISH');
