#!/usr/bin/perl

use my_inc "../..";


=pod
=head NAME

    Тестовый скрипт работы с MongoDB
    
=head DESCRIPTION

    Без параметра "action" - скрипт создаст файл, прочитает и удалит
    Возможны параметры:
        action = get|put|remove
        filename = название файла
        data = содержимое файла для действия put
        с|col|collection = название коллекции (таблицы)
        db = название бд

    Адреса серверов с БД - в Settings.pm

=cut

use warnings;
use strict;

use Settings;
use Yandex::MongoDB;
use Data::Dumper;

use ScriptHelper;

my ($action, $filename, $data, $dbname, $collection);
extract_script_params(
    'action=s' => \$action,
    'filename=s' => \$filename,
    'data=s' => \$data,
    'db=s' => \$dbname,
    'c|col|colection=s' => \$collection,
);

use utf8;

# my $mongodb_name = "test";

my $mongodb_name = $dbname || "ppcfiles";
my $mongo = Yandex::MongoDB->new(db => $mongodb_name);

if (! $action) {

    my $filename = $filename || int(100_000 * rand(1));

    my $res1 = $mongo->gridfs_put_data($collection || "api.report", "1234567890" x 2_000, {filename => "test$filename.txt"});
    print Dumper {put => $res1};

    my $res2 = $mongo->gridfs_get_data($collection || "api.report", {filename => "test$filename.txt"});
    print Dumper {get => $res2};

    my $res3 = $mongo->gridfs_remove_data($collection || "api.report", {filename => "test$filename.txt"});
    print Dumper {remove => $res3};

} else {

    if ($action eq 'put') {
        my $res1 = $mongo->gridfs_put_data($collection, ($data || ""), {filename => $filename});
        print Dumper {put => $res1};

    } elsif ($action eq 'get') {
        my $res2 = $mongo->gridfs_get_data($collection, {filename => $filename});
        print Dumper {get => $res2};

    } elsif ($action eq 'remove') {
        my $res3 = $mongo->gridfs_remove_data($collection, {filename => $filename});
        print Dumper {remove => $res3};
    }
}
