#!/usr/bin/perl

use my_inc "../..";


=head1 DESCRIPTION

$Id$

Восстанавливаем геоконтекстовые кампании, потерянные при кривой смене уид-а
(запись о старом uid была удалена, но кампания осталась привязана к нему)

Параметры:
  --shard <shard>    в каком шарде искать (def 1)
  --uid <old>=<new>  какой uid на какой меняли

=cut

use 5.010;
use strict;
use warnings;

use lib::abs '..';

use Settings;
use Yandex::DBTools;
use ScriptHelper;

use utf8;

my $shard = 1;
extract_script_params(
    "uid=s%" => \my %change,
    "shard=i" => \$shard,
);

usage()  if !%change;

$log->out('START');

while ( my ($old_uid, $new_uid) = each %change ) {

    $log->out("changing uid=$old_uid to $new_uid");

    # проверяем, что старый уид действительно удалён, и на нём остались кампании
    my $is_old_exists = get_one_field_sql(PPC(shard => $shard), 'SELECT 1 FROM users WHERE uid=?', $old_uid);
    $log->die("uid=$old_uid is not deleted")  if $is_old_exists;
    
    my $is_old_has_campaign = get_one_field_sql(PPC(shard => $shard), 'SELECT 1 FROM campaigns WHERE uid=? LIMIT 1', $old_uid);
    $log->die("uid=$old_uid doesn't have associated campaign")  if !$is_old_has_campaign;

    # проверяем, что новый клиент существует
    my $is_new_exists = get_one_field_sql(PPC(shard => $shard), 'SELECT 1 FROM users WHERE uid=?', $new_uid);
    $log->die("uid=$new_uid not exists")  if !$is_new_exists;

    # копипаст из Common::change_uid
    foreach my $r (qw/campaigns banners mediaplan_banners vcards org_details stopped_camp_users/) {
        if ($r eq 'stopped_camp_users') {
            do_delete_from_table(PPC(shard => $shard), $r, where => {uid => $new_uid});
        }
        do_update_table(PPC(shard => $shard), $r, {uid => $new_uid}, where => {uid => $old_uid});
    }
    do_sql(PPC(shard => $shard), "update ignore user_campaigns_favorite set uid = ? where uid = ?", $new_uid, $old_uid);
    do_update_table(PPCFILES, 'xls_reports',  {uid => $new_uid}, where => {uid => $old_uid});

    $log->out("all tables updated");
}

$log->out('FINISH');

