#!/usr/bin/perl

use my_inc "../..";

use strict;
use warnings;

use lib 'protected';
use Settings;
use Yandex::DBTools;
local $Yandex::DBShards::STRICT_SHARD_DBNAMES = 0;

my $select = qq{
    select
        v.worktime
    from
        campaigns c join banners b on(c.cid = b.cid) join vcards v on(b.vcard_id = v.vcard_id)
    where
        (c.sum - c.sum_spent) > 0.01 and b.statusActive = 'Yes' and b.vcard_id is not null
};

my @intervals;

my $data = get_one_column_sql(PPC, $select) || [];

for my $row (@$data) {
    my @interval_values = split(';', $row);
    $intervals[scalar(@interval_values)]++;
}

printf("all banners with vcards: %s\n", scalar(@$data));
for my $i (0 .. $#intervals){
    if($intervals[$i]){
        printf("intervals: $i, banners: $intervals[$i]\n");
    }
}
