#!/usr/bin/perl

use my_inc '../..';

=head1 NAME

block_ynd_fixed_clients.pl - блокировка клиентов в фишках

=head1 DESCRIPTION

    Скрипт разблокирует клиентов в y. e. по списку.
    Клиентам из списка ставим флаг cant_unblock и statusBlocked = 'Yes'

    Формат tsv файла:
    <ClientID>
    <ClientID>

=head1 RUNNING

    Запускать с параметрами:
        --data-file - путь к файлу со списком ClientID

    ./protected/one-shot/block_ynd_fixed_clients --data-file /home/gukserg/clientids.txt

=cut

use Direct::Modern;

use Yandex::DBTools;
use Yandex::DBShards;
use Yandex::Validate qw/is_valid_id/;
use BS::ResyncQueue;

use Path::Tiny;
use List::MoreUtils qw/part/;

use ScriptHelper;
use Settings;

use PrimitivesIds;
use Client;

my $CLIENTS_CHUNK_SIZE = 2_000;
my $CAMP_RESYNC_PRIORITY = 70;

my ($data_path);
extract_script_params(
    'data-file=s' => \$data_path,
);


$log->out('START');

my @lines = path($data_path)->lines({ chomp => 1}) or $log->die("Can't open data file $data_path: $@");
my @client_ids;
for my $line (@lines) {
    push @client_ids, $line if is_valid_id($line);
}

$log->out('Got '. scalar @client_ids .' ClientIDs from file');

foreach_shard ClientID => \@client_ids, chunk_size => $CLIENTS_CHUNK_SIZE, with_undef_shard => 1, sub {
    my ($shard, $client_id_chunk) = @_;

    # логируем записи, если не определили шард
    if (!$shard) {
        $log->out({SKIP => 1, unknown_shard_ClientIDs => $client_id_chunk});
        return;
    }

    $log->msg_prefix("[shard_$shard] ");

    # клиент должен быть в фишках
    my $clid2currencies = mass_get_client_currencies(\@client_ids);
    my ($good_curr_clids, $bad_curr_clids) = part { $clid2currencies->{$_}->{work_currency} eq 'YND_FIXED' ? 0 : 1 } @$client_id_chunk;
    if (defined $bad_curr_clids && @$bad_curr_clids) {
        $log->out({SKIP => 1, already_in_currency_client_ids => $bad_curr_clids});
    }
    # клиент не должен стоять в очереди на конвертацию
    my $clid4curr_convert = get_hash_sql(PPC(shard => $shard), ["select ClientID, 1 from currency_convert_queue", where => { ClientID => $good_curr_clids }]);
    my ($good_clids, $bad_clids) = part { defined $clid4curr_convert->{$_} ? 1 : 0 } @$good_curr_clids;
    if (defined $bad_clids && @$bad_clids) {
        $log->out({SKIP => 1, in_currency_convert_queue_client_ids => $bad_clids});
    }

    if (defined $good_clids && @$good_clids) {
        my $uids = get_uids(ClientID => $good_clids);
        my @to_insert;
        foreach my $client_id (@$good_clids) {
            push @to_insert, [$client_id, 'cant_unblock'];
        }
        # делаем insert, т. к. не у всех клиентов есть запись в таблице clients_options
        my $clients_rows_cnt = do_mass_insert_sql(PPC(shard => $shard), 'INSERT INTO clients_options (ClientID, client_flags)
                VALUES %s ON DUPLICATE KEY UPDATE client_flags = CONCAT_WS(",", client_flags, VALUES(client_flags))', \@to_insert);
        my $users_rows_cnt = do_update_table(PPC(shard => $shard), 'users', {statusBlocked => 'Yes'}, where => {uid => $uids, statusBlocked => 'No'});
        # останавливаем все кампании пользователя
        $log->out("Get campaigns for stop...");
        my $cids_for_stopping = get_one_column_sql(PPC(shard => $shard),["select cid from campaigns",
                                                                          where => {
                                                                              statusShow => "Yes",
                                                                              archived => "No",
                                                                              uid => $uids,
                                                                              type => ['text','mobile_content','performance','dynamic','mcbanner','cpm_banner','cpm_deals','cpm_yndx_frontpage']
                                                                          }]);
        if (@$cids_for_stopping) {
            $log->out({cids_for_stopping => $cids_for_stopping});
            $log->out("Stopping campaigns...");
            do_update_table(PPC(shard => $shard), 'campaigns', {
                        statusShow     => 'No',
                        LastChange__dont_quote => 'now()'}
                        , where => {cid => $cids_for_stopping, statusShow => 'Yes', archived => 'No'}
            );
            do_update_table(PPC(shard => $shard), 'camp_options', { stopTime => 'now()' }, where => { cid => $cids_for_stopping }, dont_quote => [ 'stopTime' ] );
            $log->out("Add campaigns to resync queue...");
            bs_resync_camps($cids_for_stopping, priority => $CAMP_RESYNC_PRIORITY);
        } else {
            $log->out("No campaigns to stop");
        }

        $clients_rows_cnt += 0;
        $users_rows_cnt += 0;
        $log->out({DONE => 1, blocked_client_ids => $good_clids, blocked_uids => $uids, affected_clients => $clients_rows_cnt, affected_users => $users_rows_cnt});
    }
};

$log->out('FINISH');
