#!/usr/bin/perl

# $Id$

use warnings;
use strict;
use Test::More;
use Test::Deep;
use Data::Dumper;

use Common;
use Settings;

use utf8;
use open ':std' => ':utf8';
binmode(STDERR, ":utf8");
binmode(STDOUT, ":utf8");
use Yandex::Test::UTF8Builder;
use Yandex::DBTools;

*cbs  = \&Common::calculateBannerStatus;

package Common;
sub old_calculateBannerStatus
{
    my $opt = shift;
    
    my ($camp, $banner, $phrases) = ($opt->{camp}, $opt->{banner}, $opt->{phrases});
    
    my ($message, $msg, @mess) = ({}, '');
    
    $message->{detailed_link} = defined $banner->{bid} ? "(<a href=\"#\" onclick=\"openWnd('?cmd=showDiag&bid=$banner->{bid}', 'reason', 700, 330); return false;\"><font size=\"-1\">" . iget('Подробнее') . "</font></a>)" : "";
    $message->{enable_edit} = 1;
    
    my $phone_on_moderate = $banner->{phoneflag} && $banner->{phoneflag} =~ /^(Wait|Ready|Sent)$/i;
    my $phone_accepted = $banner->{phoneflag} && $banner->{phoneflag} eq 'Yes';
    
    # объявление принято (визитка не считается при наличии ссылки)
    my $banner_draft = $banner->{statusModerate} eq 'New' || $phrases->{statusModerate} eq 'New' || $camp->{statusModerate} eq 'New';
    my $banner_on_moderate = $banner->{statusModerate} =~ /^(Ready|Sent)$/ || $phrases->{statusModerate} =~ /^(Ready|Sent)$/;
    my $banner_text_accepted = $banner->{statusModerate} eq 'Yes' && $phrases->{statusModerate} eq 'Yes';
    my $banner_text_declined = $banner->{statusModerate} eq 'No' || $phrases->{statusModerate} eq 'No';
    my $banner_accepted = $banner_text_accepted && ($banner->{href} || $phone_accepted);
    my $banner_post_accepted = $banner->{statusPostModerate} eq 'Yes' && $phrases->{statusPostModerate} eq 'Yes' && ($banner->{href} || $phone_accepted);
    my $camp_can_shows = (! $camp->{statusShow} || $camp->{statusShow} eq 'Yes') && $camp->{sum_total} > 0.001;
    
    if (defined $banner->{statusArch} && $banner->{statusArch} eq 'Yes') {
        # объявление заархивировано
        $message->{enable_edit} = 0;
    } else {
        if ($banner_on_moderate) {
            if ($banner_post_accepted) {
                $msg = $banner->{statusShow} eq 'Yes' && $camp_can_shows ? iget('Идут показы.') : iget('Принято к показам.');
                push @mess, $msg;
            } else {
                push @mess, iget("Ожидает модерации.");
            }
        }
    
        # если текст объявления(без ссылки) принят, телефон еще на модерации    
        if ($banner_text_accepted
              && !$banner->{href} && $phone_on_moderate) {
            
            push @mess, iget("Объявление принято.");
        }
        
        if ($phone_on_moderate 
                && !$banner_on_moderate
                && !$banner_text_declined) {
            
            push @mess, iget("Контактная информация ожидает модерации.");
        }
        
        if ($banner_text_declined
                && ! $banner_on_moderate) {
            
            $message->{declined_show} = 1;
            push @mess, iget('Отклонено модератором.');
        }
    
        if ($banner_text_accepted
                && !$banner->{countDeclinedPhrases}
                && $banner->{phoneflag} && $banner->{phoneflag} eq 'No') {
            
            $message->{declined_show} = 1;
            push @mess, iget('Контактная информация отклонена модератором.');
        }
        
        if ($banner_draft) {
            
            $message->{declined_show} = 0;
            push @mess, iget("Черновик");
        }
        
        if ($banner->{countDeclinedPhrases} 
                && $banner_text_accepted 
                # && $banner->{phoneflag} ne 'No'
        ) {
            
            $message->{declined_show} = 1;

            if ($banner->{phoneflag} && $banner->{phoneflag} eq "No") {
                push @mess, iget("Часть фраз и контактная информация отклонены модератором.");
            } else {
                push @mess, iget("Часть фраз отклонена.");
                
                #$message->{detailed_link} = '<a href="http://help.yandex.ru/direct/" target="_blank">?</a>'
                #    if !scalar @mess;
            }
        }

        if ($banner->{statusModerate} ne 'New'                                                              # баннер не черновик
            && $camp->{sum_total} > 0.001                                                                   # на кампании есть деньги
            && ( $banner->{statusBsSynced} ne 'Yes' 
                        || ($phrases->{statusBsSynced} ne 'Yes' && $banner->{statusShow} && $banner->{statusShow} eq 'Yes') )    # banners.statusBsSynced не Yes или phrases.statusBsSynced не Yes
            && ( !$camp->{statusShow} || $camp->{statusShow} eq 'Yes' )                                     # кампания не остановлена
            && ( $banner->{BannerID} || $banner->{statusShow} && $banner->{statusShow} eq 'Yes' )           # баннер не остановлен или был в БК
            && ( $banner->{href} || ( !$banner->{href} && $banner->{phoneflag} eq 'Yes'))                   # у баннера есть либо ссылка, либо телефон
            
            && ($banner->{BannerID} 
                    && $banner->{statusShow} eq 'No'
                    || $banner->{statusPostModerate} =~ /^(Yes|Rejected)$/ 
                        && $phrases->{statusPostModerate} =~ /^(Yes|Rejected)$/
               )
        ) {
            push @mess, iget("Идет активизация.");
        }
        
    }
    
    $message->{text} = \@mess;
    
    return $message;
}
package main;

my $plan = 10000;
Test::More::plan(tests => $plan);
my $rows = get_all_sql(PPC, qq!select b.bid, b.href, b.statusModerate,
                                   c.statusModerate as cstatusModerate,
                                   p.statusModerate as pstatusModerate,
                                   b.statusBsSynced, p.statusBsSynced as pstatusBsSynced,
                                   b.BannerID,
                                   c.sum, c.sum_spent, c.sum_to_pay, c.statusShow as cstatusShow, b.statusShow as bstatusShow,
                                   b.statusPostModerate bstatusPostModerate, p.statusPostModerate pstatusPostModerate,
                                   b.statusActive,
                                   b.statusArch,
                                   count(bids.statusModerate='No') as countDeclinedPhrases
                              from banners b
                                   join campaigns c on b.cid = c.cid
                                   join phrases p on b.pid = p.pid
                                   left join bids on bids.pid = p.pid
                                   where b.statusModerate = 'Sent' and b.statusPostModerate = 'Yes' and c.archived = 'No'
                              group by (b.bid)
                              limit $plan!);
my %seen_fails = ();
for my $vars (@$rows) {
    my $banner_status_options= {
        banner => {
            statusModerate => $vars->{statusModerate}, 
            statusPostModerate => $vars->{bstatusPostModerate},
            statusBsSynced => $vars->{statusBsSynced}, 
            statusArch => undef, #$vars->{statusArch}, # а разве мы не хотим выводить сообщение "баннер заархивирован" ?
            BannerID => $vars->{BannerID},
            bid => $vars->{bid},
            statusShow => $vars->{bstatusShow},
            statusActive => $vars->{statusActive},
            phoneflag => $vars->{phoneflag},
            href => $vars->{href},
            countDeclinedPhrases => $vars->{countDeclinedPhrases},            
        },
        phrases => {
            statusModerate => $vars->{pstatusModerate}, 
            statusPostModerate => $vars->{pstatusPostModerate},
            statusBsSynced => $vars->{pstatusBsSynced},
        },
        camp => {
            sum_total => $vars->{sum} - $vars->{sum_spent},
            statusModerate => $vars->{cstatusModerate},
            statusShow => $vars->{cstatusShow},
            sum_to_pay => $vars->{sum_to_pay},
        }
        
    };
    unless(cmp_deeply(cbs($banner_status_options)->{text}, Common::old_calculateBannerStatus($banner_status_options)->{text})) {
    print "\n\n\n";
    print $banner_status_options->{banner}->{bid} . "\n";
    print Dumper($banner_status_options);
    print "\n\n\n";
        my $fail_label = join(' ', @{cbs($banner_status_options)->{text}}) . " <===> " . join(' ', @{Common::old_calculateBannerStatus($banner_status_options)->{text}});
        unless( $seen_fails{ $fail_label } ) {
            print Dumper($banner_status_options);
            print $fail_label . "\n";
        }
        $seen_fails{ $fail_label }++;
    }
}
