#!/usr/bin/perl

use my_inc "../..";


# $Id$

use warnings;
use strict;

use Common;
use Models::Banner;
use Settings;

use utf8;
use open ':std' => ':utf8';
binmode(STDERR, ":utf8");
binmode(STDOUT, ":utf8");
use Yandex::DBTools;

BEGIN {
*cbs  = \&Models::Banner::calculateBannerStatus;
*ccs  = \&Common::CalcCampStatus;
}

my $rows = get_all_sql(PPC, qq!select b.bid, b.href, b.statusModerate as bstatusModerate,
                                   c.statusModerate as cstatusModerate,
                                   p.statusModerate as pstatusModerate,
                                   b.statusBsSynced as bstatusBsSynced, p.statusBsSynced as pstatusBsSynced,
                                   b.BannerID, b.phoneflag,
                                   c.sum, c.sum_spent, c.sum_to_pay, c.statusShow as cstatusShow, b.statusShow as bstatusShow,
                                   b.statusPostModerate bstatusPostModerate, p.statusPostModerate pstatusPostModerate,
                                   b.statusActive bstatusActive,
                                   b.statusArch bstatusArch,
                                   count(bids.statusModerate='No') as countDeclinedPhrases,
                                   DATE_FORMAT(c.start_time, '%Y%m%d000000') as start_time, c.OrderID, c.statusActive as cstatusActive, co.statusPostModerate as cstatusPostModerate, c.timeTarget, c.timezone_id,
                                   c.statusBsSynced as cstatusBsSynced, co.stopTime
                              from banners b
                                   join campaigns c on b.cid = c.cid
                                   left join camp_options co on co.cid = c.cid
                                   join phrases p on b.pid = p.pid
                                   left join bids on bids.pid = p.pid
                              where c.archived = 'No'
                              group by (b.bid)
                              limit 500000 
                              !);

my @fields = qw/BannerID bid bstatusActive bstatusBsSynced bstatusModerate bstatusPostModerate bstatusShow countDeclinedPhrases cstatusActive cstatusBsSynced cstatusModerate cstatusPostModerate cstatusShow href OrderID phoneflag pstatusBsSynced pstatusModerate pstatusPostModerate start_time stopTime sum sum_spent sum_to_pay timeTarget timezone_id/;
print join("\t", @fields, qw/camp_status banner_status_text banner_status_warning/) . "\n";


my %seen = ();

for my $vars (@$rows) {
    my $banner_status_options= {
        banner => {
            statusModerate => $vars->{bstatusModerate}, 
            statusPostModerate => $vars->{bstatusPostModerate},
            statusBsSynced => $vars->{bstatusBsSynced}, 
            statusArch => undef, #$vars->{bstatusArch}, # а разве мы не хотим выводить сообщение "баннер заархивирован" ?
            BannerID => $vars->{BannerID},
            bid => $vars->{bid},
            statusShow => $vars->{bstatusShow},
            statusActive => $vars->{bstatusActive},
            phoneflag => $vars->{phoneflag},
            href => $vars->{href},
            countDeclinedPhrases => $vars->{countDeclinedPhrases},            
        },
        phrases => {
            statusModerate => $vars->{pstatusModerate}, 
            statusPostModerate => $vars->{pstatusPostModerate},
            statusBsSynced => $vars->{pstatusBsSynced},
        },
        camp => {
            sum_total => $vars->{sum} - $vars->{sum_spent},
            statusModerate => $vars->{cstatusModerate},
            statusShow => $vars->{cstatusShow},
            sum_to_pay => $vars->{sum_to_pay},
        }
        
    };
    my $camp_status_options = {
        sum => $vars->{sum},
        sum_spent => $vars->{sum_spent},
        start_time => $vars->{start_time},
        statusModerate => $vars->{cstatusModerate},
        OrderID => $vars->{OrderID},
        statusShow => $vars->{cstatusShow},
        statusActive => $vars->{cstatusActive},
        statusPostModerate => $vars->{cstatusPostModerate},
        timeTarget => $vars->{timeTarget},
        timezone_id => $vars->{timezone_id},
        sum_to_pay => $vars->{sum_to_pay},
        statusBsSynced => $vars->{cstatusBsSynced},
        stopTime => $vars->{stopTime},
    };
    my $banner_status = cbs($banner_status_options);
    my $camp_status   = ccs($camp_status_options);
    no warnings;
    my $serialized = _serialize($vars);
    unless ($seen{$serialized}) {
        print join("\t", @$vars{ @fields }, $camp_status, join(' ', @{$banner_status->{text}}), $banner_status->{warning} ) . "\n";
        $seen{$serialized} = 1;
    }
}

sub _serialize
{
    my $vars = shift;

    no warnings;
    return join('|', @$vars{ qw/
        bstatusActive bstatusBsSynced bstatusModerate bstatusPostModerate bstatusShow cstatusActive cstatusBsSynced cstatusModerate cstatusPostModerate cstatusShow phoneflag pstatusBsSynced pstatusModerate pstatusPostModerate 
        / }, map {!!$vars->{$_}} qw/BannerID countDeclinedPhrases href OrderID sum sum_spent sum_to_pay timeTarget start_time stopTime timezone_id/);
}

