#!/usr/bin/perl

use Direct::Modern;

use Yandex::DBTools;
use Yandex::ListUtils qw/chunks/;

use my_inc '../..';

use ScriptHelper;
use Settings;
use ShardingTools qw/foreach_shard_parallel_verbose/;

$log->out('START');

foreach_shard_parallel_verbose($log, sub {
    my $shard = shift;
    while (my $cids = get_next_camps($shard)) {
        
        $log->out(sprintf "try to update %d campaigns", scalar @$cids);

        for my $cids_chunk (chunks $cids, 1000) {
            do_sql(PPC(shard => $shard), [
                "UPDATE camp_options SET minus_words = NULL",
                WHERE => {cid => $cids_chunk},
               "AND minus_words IS NOT NULL AND length(minus_words) = 0"
            ]);
            $log->out(sprintf "set default null for %s", join ",", @$cids_chunk);
        }
    }
});

$log->out('FINISH');


sub get_next_camps {

    my $shard = shift;

    state $last_cid = 0;

    my $cids = get_one_column_sql(PPC(shard => $shard),
        "SELECT cid FROM camp_options WHERE minus_words IS NOT NULL AND length(minus_words) = 0 AND cid > ? ORDER BY cid LIMIT 20000", 
        $last_cid);

    return undef unless @$cids;

    $last_cid = $cids->[-1];
    $log->out(sprintf "looked cid %d", $last_cid);
    return $cids;
}
